/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.attachments;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.attachments.AttachmentTableModel;
import com.eviware.soapui.impl.wsdl.panels.attachments.ContentTypeHandler;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.model.iface.Attachment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class RequestAttachmentTableModel
extends AbstractTableModel
implements PropertyChangeListener,
AttachmentTableModel {
    WsdlRequest request;
    boolean isRequest = false;

    public RequestAttachmentTableModel(WsdlRequest request, boolean isRequest) {
        this.request = request;
        this.isRequest = isRequest;
        request.addPropertyChangeListener(WsdlRequest.ATTACHMENTS_PROPERTY, this);
        request.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
    }

    public void release() {
        this.request.removePropertyChangeListener(this);
    }

    public void addFile(File file, boolean cacheInRequest) throws IOException {
        if (this.isRequest) {
            Attachment attachment = this.request.attachFile(file, cacheInRequest);
            attachment.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
        }
        this.fireTableRowsInserted(this.request.getAttachmentCount(), this.request.getAttachmentCount());
    }

    public void removeAttachment(int[] rowIndexes) {
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.removeAttachment(rowIndexes[i]);
        }
    }

    public void removeAttachment(int rowIndex) {
        if (this.isRequest) {
            this.request.removeAttachment(this.request.getAttachmentAt(rowIndex));
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public int getRowCount() {
        if (this.isRequest) {
            return this.request.getAttachmentCount();
        }
        try {
            return this.request.getResponse().getAttachments().length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getColumnCount() {
        return this.isRequest ? 6 : 5;
    }

    public Attachment getAttachmentAt(int rowIndex) {
        if (this.isRequest) {
            return this.request.getAttachmentAt(rowIndex);
        }
        return this.request.getResponse().getAttachments()[rowIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount()) {
            return null;
        }
        Attachment att = null;
        att = this.isRequest ? this.request.getAttachmentAt(rowIndex) : this.request.getResponse().getAttachments()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return att.getName();
            }
            case 1: {
                return att.getContentType();
            }
            case 2: {
                return att.getSize();
            }
            case 3: {
                return att.getPart();
            }
            case 4: {
                return att.getAttachmentType();
            }
            case 5: {
                return att.getContentID();
            }
        }
        return null;
    }

    public int findColumn(String columnName) {
        if (columnName.equals("Name")) {
            return 0;
        }
        if (columnName.equals("Content type")) {
            return 1;
        }
        if (columnName.equals("Size")) {
            return 2;
        }
        if (columnName.equals("Part")) {
            return 3;
        }
        if (columnName.equals("Type")) {
            return 4;
        }
        return -1;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Content type";
        }
        if (column == 2) {
            return "Size";
        }
        if (column == 3) {
            return "Part";
        }
        if (column == 4) {
            return "Type";
        }
        if (column == 5) {
            return "ContentID";
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isRequest && (columnIndex == 1 || columnIndex == 3 || columnIndex == 5);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isRequest) {
            return;
        }
        WsdlAttachment att = (WsdlAttachment)this.request.getAttachmentAt(rowIndex);
        if (columnIndex == 1) {
            att.setContentType((String)aValue);
        } else if (columnIndex == 3) {
            att.setPart((String)aValue);
        } else if (columnIndex == 5) {
            att.setContentID((String)aValue);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }
}

