/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.Tools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public abstract class FileAttachment
implements WsdlAttachment {
    private AttachmentConfig config;
    private static final Logger log = Logger.getLogger(FileAttachment.class);

    public FileAttachment(AttachmentConfig config) {
        this.config = config;
        if (config.getTempFilename() != null) {
            try {
                log.info((Object)("Moving locally cached file [" + config.getTempFilename() + "] to internal cache.."));
                File tempFile = new File(config.getTempFilename());
                this.cacheFileLocally(tempFile);
            }
            catch (IOException e) {
                if (!config.isSetData()) {
                    config.setData(new byte[0]);
                    config.setSize(0L);
                }
                e.printStackTrace();
            }
        }
        if (this.isCached()) {
            if (config.isSetTempFilename()) {
                config.unsetTempFilename();
            }
            if (config.isSetUrl()) {
                config.unsetUrl();
            }
        }
    }

    public FileAttachment(File file, boolean cache, AttachmentConfig config) throws IOException {
        this(config);
        config.setName(file.getName());
        if (cache) {
            this.cacheFileLocally(file);
        } else {
            config.setUrl(file.getPath());
        }
    }

    private void cacheFileLocally(File file) throws FileNotFoundException, IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(data);
        out.putNextEntry(new ZipEntry(this.config.getName()));
        FileInputStream in = new FileInputStream(file);
        long sz = file.length();
        this.config.setSize(sz);
        Tools.writeAll(out, in);
        ((InputStream)in).close();
        out.closeEntry();
        out.finish();
        out.close();
        data.close();
        this.config.setData(data.toByteArray());
    }

    public String getContentType() {
        return this.config.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isCached()) {
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.config.getData()));
            zipInputStream.getNextEntry();
            return new BufferedInputStream(zipInputStream);
        }
        return new BufferedInputStream(new FileInputStream(this.config.getUrl()));
    }

    public String getName() {
        return this.config.getName();
    }

    public long getSize() {
        if (this.isCached()) {
            return this.config.getSize();
        }
        return new File(this.config.getUrl()).length();
    }

    public void release() {
        if (this.isCached()) {
            new File(this.config.getTempFilename()).delete();
        }
    }

    public String getPart() {
        return this.config.getPart();
    }

    public void setContentType(String contentType) {
        this.config.setContentType(contentType);
    }

    public void setPart(String part) {
        this.config.setPart(part);
    }

    public String getUrl() {
        if (this.isCached()) {
            String name = this.config.getName();
            int ix = name.lastIndexOf(".");
            try {
                File tempFile = File.createTempFile("attachment-" + name.substring(0, ix), name.substring(ix));
                FileOutputStream out = new FileOutputStream(tempFile);
                InputStream in = this.getInputStream();
                Tools.writeAll(out, in);
                out.close();
                in.close();
                return tempFile.getAbsoluteFile().toURL().toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return this.config.getUrl();
        }
        return null;
    }

    public boolean isCached() {
        return this.config.isSetData();
    }

    public abstract Attachment.AttachmentType getAttachmentType();

    public void updateConfig(AttachmentConfig config) {
        this.config = config;
    }

    public AttachmentConfig getConfig() {
        return this.config;
    }

    public void setContentID(String contentID) {
        if ((contentID == null || contentID.length() == 0) && this.config.isSetContentId()) {
            this.config.unsetContentId();
        } else {
            this.config.setContentId(contentID);
        }
    }

    public String getContentID() {
        return this.config.getContentId();
    }
}

