/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.Tools;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class WsdlLoader
implements WSDLLocator {
    private final String url;
    private String last;
    protected static final Logger log = Logger.getLogger(WsdlLoader.class);

    public WsdlLoader(String url) {
        this.url = url;
    }

    public InputSource getBaseInputSource() {
        try {
            log.debug((Object)("Returning baseInputSource [" + this.url + "]"));
            return new InputSource(this.load(this.url));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public abstract InputStream load(String var1) throws Exception;

    public XmlObject loadXmlObject(String url, XmlOptions options) throws Exception {
        if (options == null) {
            return XmlObject.Factory.parse((InputStream)this.load(url), (XmlOptions)new XmlOptions().setLoadLineNumbers());
        }
        options.setLoadLineNumbers();
        return XmlObject.Factory.parse((InputStream)this.load(url), (XmlOptions)options);
    }

    public String getBaseURI() {
        log.debug((Object)("Returning baseURI [" + this.url + "]"));
        return this.url;
    }

    public InputSource getImportInputSource(String parent, String imp) {
        this.last = this.isAbsoluteUrl(imp) ? imp : Tools.joinRelativeUrl(parent, imp);
        try {
            return new InputSource(this.load(this.last));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected boolean isAbsoluteUrl(String tempImp) {
        return (tempImp = tempImp.toUpperCase()).startsWith("HTTP:") || tempImp.startsWith("HTTPS:") || tempImp.startsWith("FILE:");
    }

    public String getLatestImportURI() {
        String result = this.last == null ? this.url : this.last;
        log.debug((Object)("Returning latest import URI [" + result + "]"));
        return result;
    }

    public abstract boolean abort();

    public abstract boolean isAborted();

    public static DefinitionCacheConfig cacheWsdl(WsdlLoader loader) throws Exception {
        DefinitionCacheConfig definitionCache = DefinitionCacheConfig.Factory.newInstance();
        definitionCache.setRootPart(loader.getBaseURI());
        Map<String, XmlObject> urls = SchemaUtils.getDefinitionParts(loader);
        Iterator<String> i = urls.keySet().iterator();
        while (i.hasNext()) {
            DefintionPartConfig definitionPart = definitionCache.addNewPart();
            String url = i.next();
            definitionPart.setUrl(url);
            XmlObject xmlObject = urls.get(url);
            definitionPart.setContent(xmlObject);
            Document domNode = (Document)xmlObject.getDomNode();
            definitionPart.setType(domNode.getDocumentElement().getNamespaceURI());
        }
        return definitionCache;
    }
}

