/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class CloneTestStepAction
extends AbstractAction {
    private final WsdlTestStep testStep;
    private final String typeName;

    public CloneTestStepAction(WsdlTestStep testStep, String typeName) {
        super("Clone");
        this.testStep = testStep;
        this.typeName = typeName;
        this.putValue("ShortDescription", "Creates a copy of this " + typeName);
        this.putValue("SmallIcon", UISupport.createImageIcon("/clone_request.gif"));
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("F9"));
    }

    public void actionPerformed(ActionEvent e) {
        WsdlTestCase testCase = this.testStep.getTestCase();
        WsdlProject project = testCase.getTestSuite().getProject();
        ArrayList<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
        ArrayList<String> options = new ArrayList<String>();
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            TestSuite testSuite = project.getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                testCase = (WsdlTestCase)testSuite.getTestCaseAt(i);
                testCases.add(testCase);
                options.add(testSuite.getName() + " : " + testCase.getName());
            }
        }
        if (options.size() > 1) {
            String testCaseName = (String)UISupport.prompt("Select TestCase to clone to", "Clone " + this.typeName, options.toArray(), this.testStep.getTestCase().getTestSuite().getName() + " : " + this.testStep.getTestCase().getName());
            if (testCaseName == null) {
                return;
            }
            testCase = (WsdlTestCase)testCases.get(options.indexOf(testCaseName));
        }
        if (SoapUI.getTestMonitor().hasRunningTest(testCase)) {
            UISupport.showErrorMessage("Cannot clone to running TestCase");
            return;
        }
        String name = UISupport.prompt("Specify name of cloned " + this.typeName, "Clone " + this.typeName, "Copy of " + this.testStep.getName());
        if (name == null) {
            return;
        }
        WsdlTestStep newStep = testCase.cloneStep(this.testStep, name);
        UISupport.selectAndShow(newStep);
    }
}

