/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.impl.wsdl.actions.testcase.AddNewLoadTestAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.AbstractTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.LoadTestTreeNode;
import com.eviware.soapui.model.tree.nodes.TestStepTreeNode;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseTreeNode
extends AbstractModelItemTreeNode<TestCase> {
    private TestStepsTreeNode testStepsNode = new TestStepsTreeNode();
    private LoadTestsTreeNode loadTestsNode = new LoadTestsTreeNode();
    private InternalTestSuiteListener internalTestSuiteListener;

    public TestCaseTreeNode(TestCase testCase, SoapUITreeModel treeModel) {
        super(testCase, testCase.getTestSuite(), treeModel);
        this.getTreeModel().mapModelItem(this.testStepsNode);
        this.getTreeModel().mapModelItem(this.loadTestsNode);
        this.internalTestSuiteListener = new InternalTestSuiteListener();
        testCase.getTestSuite().addTestSuiteListener(this.internalTestSuiteListener);
    }

    @Override
    public void release() {
        super.release();
        this.getTestCase().getTestSuite().removeTestSuiteListener(this.internalTestSuiteListener);
        this.testStepsNode.release();
        this.loadTestsNode.release();
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        if (index == 0) {
            return this.testStepsNode;
        }
        if (index == 1) {
            return this.loadTestsNode;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object child) {
        if (child == this.testStepsNode) {
            return 0;
        }
        if (child == this.loadTestsNode) {
            return 1;
        }
        return -1;
    }

    public LoadTestsTreeNode getLoadTestsNode() {
        return this.loadTestsNode;
    }

    public TestStepsTreeNode getTestStepsNode() {
        return this.testStepsNode;
    }

    public TestCase getTestCase() {
        return (TestCase)this.getModelItem();
    }

    public void testStepInserted(TestStep testStep, int index) {
        this.testStepsNode.testStepInserted(testStep, index);
    }

    public void testStepRemoved(TestStep testStep, int index) {
        this.testStepsNode.testStepRemoved(testStep, index);
    }

    public void loadTestInserted(LoadTest loadTest) {
        this.loadTestsNode.loadTestInserted(loadTest);
    }

    public void loadTestRemoved(LoadTest loadTest) {
        this.loadTestsNode.loadTestRemoved(loadTest);
    }

    public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
        this.testStepsNode.testStepMoved(testStep, fromIndex, offset);
    }

    public class InternalTestSuiteListener
    extends TestSuiteListenerAdapter
    implements TestSuiteListener {
        public void testStepAdded(TestStep testStep, int index) {
            TestCaseTreeNode.this.testStepsNode.updateLabel();
        }

        public void testStepRemoved(TestStep testStep, int index) {
            TestCaseTreeNode.this.testStepsNode.updateLabel();
        }

        public void loadTestAdded(LoadTest loadTest) {
            TestCaseTreeNode.this.loadTestsNode.updateLabel();
        }

        public void loadTestRemoved(LoadTest loadTest) {
            TestCaseTreeNode.this.loadTestsNode.updateLabel();
        }
    }

    public class LoadTestsTreeNode
    extends AbstractTreeNode {
        private List<LoadTestTreeNode> loadTestNodes;

        protected LoadTestsTreeNode() {
            super("Load Tests (" + TestCaseTreeNode.this.getTestCase().getLoadTestCount() + ")", UISupport.createImageIcon("/loadtests.gif"));
            this.loadTestNodes = new ArrayList<LoadTestTreeNode>();
            for (int c = 0; c < TestCaseTreeNode.this.getTestCase().getLoadTestCount(); ++c) {
                this.loadTestNodes.add(new LoadTestTreeNode(TestCaseTreeNode.this.getTestCase().getLoadTestAt(c), this.getModelItem(), TestCaseTreeNode.this.getTreeModel()));
            }
            TestCaseTreeNode.this.getTreeModel().mapModelItems(this.loadTestNodes);
            this.addAction(new AddNewLoadTestAction((WsdlTestCase)TestCaseTreeNode.this.getTestCase()), false);
        }

        public int getChildCount() {
            return this.loadTestNodes.size();
        }

        public int getIndexOfChild(Object child) {
            return this.loadTestNodes.indexOf(child);
        }

        public SoapUITreeNode getChildNode(int index) {
            return this.loadTestNodes.get(index);
        }

        public SoapUITreeNode getParentTreeNode() {
            return TestCaseTreeNode.this;
        }

        public void loadTestInserted(LoadTest loadTest) {
            LoadTestTreeNode loadTestTreeNode = new LoadTestTreeNode(loadTest, this.getModelItem(), TestCaseTreeNode.this.getTreeModel());
            this.loadTestNodes.add(loadTestTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeInserted(loadTestTreeNode);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            SoapUITreeNode treeNode = TestCaseTreeNode.this.getTreeModel().getTreeNode(loadTest);
            if (!this.loadTestNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown loadTest");
            }
            TestCaseTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            this.loadTestNodes.remove(treeNode);
        }

        public void release() {
            for (LoadTestTreeNode loadTestNode : this.loadTestNodes) {
                loadTestNode.release();
            }
        }

        public void updateLabel() {
            this.setLabel("Load Tests (" + TestCaseTreeNode.this.getTestCase().getLoadTestCount() + ")");
        }
    }

    public class TestStepsTreeNode
    extends AbstractTreeNode {
        private List<TestStepTreeNode> testStepNodes;

        protected TestStepsTreeNode() {
            super("Test Steps (" + TestCaseTreeNode.this.getTestCase().getTestStepCount() + ")", UISupport.createImageIcon("/teststeps.gif"));
            this.testStepNodes = new ArrayList<TestStepTreeNode>();
            for (int c = 0; c < TestCaseTreeNode.this.getTestCase().getTestStepCount(); ++c) {
                this.testStepNodes.add(new TestStepTreeNode(TestCaseTreeNode.this.getTestCase().getTestStepAt(c), this.getModelItem(), TestCaseTreeNode.this.getTreeModel()));
            }
            TestCaseTreeNode.this.getTreeModel().mapModelItems(this.testStepNodes);
            this.addAction(TestCaseTreeNode.this.getTestCase().getActions().getDefaultAction(), true);
            this.addAction(new ActionSupport.ActionListAction(((WsdlTestCase)TestCaseTreeNode.this.getTestCase()).getCreateActions()), false);
        }

        public void updateLabel() {
            this.setLabel("Test Steps (" + TestCaseTreeNode.this.getTestCase().getTestStepCount() + ")");
        }

        public int getChildCount() {
            return this.testStepNodes.size();
        }

        public int getIndexOfChild(Object child) {
            return this.testStepNodes.indexOf(child);
        }

        public SoapUITreeNode getChildNode(int index) {
            return this.testStepNodes.get(index);
        }

        public SoapUITreeNode getParentTreeNode() {
            return TestCaseTreeNode.this;
        }

        public void testStepInserted(TestStep testStep, int index) {
            TestStepTreeNode testStepTreeNode = new TestStepTreeNode(testStep, this.getModelItem(), TestCaseTreeNode.this.getTreeModel());
            this.testStepNodes.add(index, testStepTreeNode);
            TestCaseTreeNode.this.getTreeModel().notifyNodeInserted(testStepTreeNode);
        }

        public void testStepRemoved(TestStep testStep, int index) {
            SoapUITreeNode treeNode = TestCaseTreeNode.this.getTreeModel().getTreeNode(testStep);
            if (!this.testStepNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown testStep");
            }
            TestCaseTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            this.testStepNodes.remove(treeNode);
        }

        public void testStepMoved(TestStep testStep, int fromIndex, int offset) {
            this.testStepRemoved(testStep, fromIndex);
            this.testStepInserted(testStep, fromIndex + offset);
        }

        public void release() {
            for (TestStepTreeNode testStepNode : this.testStepNodes) {
                testStepNode.release();
            }
        }
    }
}

