/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action;

import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.MarkerAction;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ActionSupport {
    public static final Action SEPARATOR_ACTION = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
        }
    };

    public static JPopupMenu buildPopup(ActionList actions) {
        JPopupMenu popup = new JPopupMenu(actions.getLabel());
        return ActionSupport.addActions(actions, popup);
    }

    public static JMenu buildMenu(ActionList actions) {
        JMenu menu = new JMenu(actions.getLabel());
        return ActionSupport.addActions(actions, menu);
    }

    public static JPopupMenu addActions(ActionList actions, JPopupMenu popup) {
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                popup.addSeparator();
                continue;
            }
            if (action instanceof ActionListAction) {
                popup.add(ActionSupport.buildMenu(((ActionListAction)action).getActionList()));
                continue;
            }
            popup.add(action);
        }
        return popup;
    }

    public static JMenu addActions(ActionList actions, JMenu menu) {
        if (actions == null || menu == null) {
            return menu;
        }
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                menu.addSeparator();
                continue;
            }
            if (action instanceof ActionListAction) {
                menu.add(ActionSupport.buildMenu(((ActionListAction)action).getActionList()));
                continue;
            }
            menu.add(action);
        }
        return menu;
    }

    public static JPopupMenu insertActions(ActionList actions, JPopupMenu popup, int index) {
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                popup.insert(new JPopupMenu.Separator(), index + i);
                continue;
            }
            if (action instanceof ActionListAction) {
                popup.insert(ActionSupport.buildMenu(((ActionListAction)action).getActionList()), index + i);
                continue;
            }
            popup.insert(action, index + i);
        }
        return popup;
    }

    public static void addActions(ActionList actionList, ButtonBarBuilder builder) {
        for (int c = 0; c < actionList.getActionCount(); ++c) {
            Action action = actionList.getActionAt(c);
            if (action == SEPARATOR_ACTION) {
                builder.addUnrelatedGap();
                continue;
            }
            if (c > 0) {
                builder.addRelatedGap();
            }
            builder.addFixed((JComponent)new JButton(action));
        }
    }

    public static class ActionListAction
    extends AbstractAction {
        private final ActionList actionList;

        public ActionListAction(ActionList actionList) {
            this.actionList = actionList;
        }

        public ActionList getActionList() {
            return this.actionList;
        }

        public void actionPerformed(ActionEvent e) {
            Action defaultAction = this.actionList.getDefaultAction();
            if (defaultAction != null) {
                defaultAction.actionPerformed(e);
            }
        }
    }
}

