/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.gui.DirectoryPanel;
import org.apache.ftpserver.gui.FilePanel;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FileObserver;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.interfaces.StatisticsObserver;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.DateUtils;

public class StatisticsPanel
extends PluginPanel
implements StatisticsObserver,
FileObserver,
TableModel {
    private static final long serialVersionUID = -8316984131627702453L;
    private static final int I_START_TIME = 0;
    private static final int I_DIR_CREATED = 1;
    private static final int I_DIR_REMOVED = 2;
    private static final int I_FILE_UPLOAD = 3;
    private static final int I_FILE_DOWNLOAD = 4;
    private static final int I_FILE_REMOVED = 5;
    private static final int I_UPLOAD_BYTES = 6;
    private static final int I_DOWNLOAD_BYTES = 7;
    private static final int I_CURR_LOGINS = 8;
    private static final int I_TOTAL_LOGINS = 9;
    private static final int I_CURR_ANON_LOGINS = 10;
    private static final int I_TOTAL_ANON_LOGINS = 11;
    private static final int I_TOTAL_LOGIN_FAILS = 12;
    private static final int I_CURR_CONS = 13;
    private static final int I_TOTAL_CONS = 14;
    private static final String[] COL_NAMES = new String[]{"Name", "Value"};
    private static final String[] STAT_NAMES = new String[]{"Server start time", "Number of directories created", "Number of directories removed", "Number of files uploaded", "Number of files downloaded", "Number of files deleted", "Uploaded bytes", "Downloaded bytes", "Current logins", "Total logins", "Current anonymous logins", "Total anonymous logins", "Total failed logins", "Current connections", "Total connections"};
    private FtpServerContext serverContext;
    private ServerFtpStatistics statistics;
    private String[] data = new String[STAT_NAMES.length];
    private EventListenerList listeners = new EventListenerList();

    public StatisticsPanel(PluginPanelContainer container) {
        super(container);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = "";
        }
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JTable dataTable = new JTable(this);
        JScrollPane scrollPane = new JScrollPane(dataTable, 20, 31);
        this.add((Component)scrollPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.add((Component)btnPanel, "South");
        JButton reloadButton = new JButton("Reload");
        btnPanel.add(reloadButton);
        reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.refresh(StatisticsPanel.this.serverContext);
            }
        });
        JButton resetButton = new JButton("Reset");
        btnPanel.add(resetButton);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatisticsPanel.this.resetStats(StatisticsPanel.this.serverContext);
            }
        });
    }

    public Class getColumnClass(int index) {
        return String.class;
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int index) {
        return COL_NAMES[index];
    }

    public int getRowCount() {
        return STAT_NAMES.length;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return STAT_NAMES[rowIndex];
        }
        return this.data[rowIndex];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(TableModelListener.class, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(TableModelListener.class, l);
    }

    private void setValue(int index, String val) {
        if (val == null) {
            val = "";
        }
        this.data[index] = val;
        TableModelEvent e = new TableModelEvent(this, index, index, 1);
        Object[] listenerList = this.listeners.getListenerList();
        for (int i = listenerList.length - 2; i >= 0; i -= 2) {
            if (listenerList[i] != (class$javax$swing$event$TableModelListener == null ? StatisticsPanel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listenerList[i + 1]).tableChanged(e);
        }
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        if (this.serverContext != null) {
            this.statistics = (ServerFtpStatistics)this.serverContext.getFtpStatistics();
            this.statistics.setObserver((StatisticsObserver)this);
            this.statistics.setFileObserver((FileObserver)this);
            String startTime = DateUtils.getISO8601Date((long)this.statistics.getStartTime().getTime());
            this.setValue(0, startTime);
            this.notifyMkdir();
            this.notifyRmdir();
            this.notifyUpload();
            this.notifyDownload();
            this.notifyDelete();
            this.notifyLogin(true);
            this.notifyLoginFail(null);
            this.notifyOpenConnection();
        } else {
            if (this.statistics != null) {
                this.statistics.setObserver(null);
                this.statistics.setFileObserver(null);
            }
            this.statistics = null;
        }
    }

    public void resetStats(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        if (this.serverContext != null) {
            this.statistics = (ServerFtpStatistics)this.serverContext.getFtpStatistics();
            this.statistics.resetStatisticsCounters();
            this.refresh(serverContext);
        }
    }

    public void notifyUpload() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int totalUpload = stat.getTotalUploadNumber();
                    StatisticsPanel.this.setValue(3, String.valueOf(totalUpload));
                    long totalUploadSz = stat.getTotalUploadSize();
                    StatisticsPanel.this.setValue(6, String.valueOf(totalUploadSz));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyUpload(final Connection connection, final FileObject file, final long size) {
        Runnable runnable = new Runnable(){

            public void run() {
                FilePanel filePanel = (FilePanel)StatisticsPanel.this.getContainer().getPluginPanel(6);
                filePanel.notifyUpload(connection, file, size);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyDownload() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int totalDownload = stat.getTotalDownloadNumber();
                    StatisticsPanel.this.setValue(4, String.valueOf(totalDownload));
                    long totalDownloadSz = stat.getTotalDownloadSize();
                    StatisticsPanel.this.setValue(7, String.valueOf(totalDownloadSz));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyDownload(final Connection connection, final FileObject file, final long size) {
        Runnable runnable = new Runnable(){

            public void run() {
                FilePanel filePanel = (FilePanel)StatisticsPanel.this.getContainer().getPluginPanel(6);
                filePanel.notifyDownload(connection, file, size);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyDelete() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int totalDelete = stat.getTotalDeleteNumber();
                    StatisticsPanel.this.setValue(5, String.valueOf(totalDelete));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyDelete(final Connection connection, final FileObject file) {
        Runnable runnable = new Runnable(){

            public void run() {
                FilePanel filePanel = (FilePanel)StatisticsPanel.this.getContainer().getPluginPanel(6);
                filePanel.notifyDelete(connection, file);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyLogin(final boolean anonymous) {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int loginNbr = stat.getCurrentLoginNumber();
                    StatisticsPanel.this.setValue(8, String.valueOf(loginNbr));
                    int totalLoginNbr = stat.getTotalLoginNumber();
                    StatisticsPanel.this.setValue(9, String.valueOf(totalLoginNbr));
                    if (anonymous) {
                        int anonLoginNbr = stat.getCurrentAnonymousLoginNumber();
                        StatisticsPanel.this.setValue(10, String.valueOf(anonLoginNbr));
                        int totalAnonLoginNbr = stat.getTotalAnonymousLoginNumber();
                        StatisticsPanel.this.setValue(11, String.valueOf(totalAnonLoginNbr));
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyLogout(boolean anonymous) {
        this.notifyLogin(anonymous);
    }

    public void notifyLoginFail(InetAddress address) {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int failedNbr = stat.getTotalFailedLoginNumber();
                    StatisticsPanel.this.setValue(12, String.valueOf(failedNbr));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyOpenConnection() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int currCon = stat.getCurrentConnectionNumber();
                    StatisticsPanel.this.setValue(13, String.valueOf(currCon));
                    int totalCon = stat.getTotalConnectionNumber();
                    StatisticsPanel.this.setValue(14, String.valueOf(totalCon));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyCloseConnection() {
        this.notifyOpenConnection();
    }

    public void notifyMkdir() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int totalMkdir = stat.getTotalDirectoryCreated();
                    StatisticsPanel.this.setValue(1, String.valueOf(totalMkdir));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyMkdir(final Connection connection, final FileObject file) {
        Runnable runnable = new Runnable(){

            public void run() {
                DirectoryPanel dirPanel = (DirectoryPanel)StatisticsPanel.this.getContainer().getPluginPanel(7);
                dirPanel.notifyMkdir(connection, file);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyRmdir() {
        Runnable runnable = new Runnable(){

            public void run() {
                ServerFtpStatistics stat = StatisticsPanel.this.statistics;
                if (stat != null) {
                    int totalRmdir = stat.getTotalDirectoryRemoved();
                    StatisticsPanel.this.setValue(2, String.valueOf(totalRmdir));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void notifyRmdir(final Connection connection, final FileObject file) {
        Runnable runnable = new Runnable(){

            public void run() {
                DirectoryPanel dirPanel = (DirectoryPanel)StatisticsPanel.this.getContainer().getPluginPanel(7);
                dirPanel.notifyRmdir(connection, file);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Statistics";
    }
}

