/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.Serializable;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.couriers.JmsCourier;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.helpers.KeyValuePair;

public class JMSUtil {
    private static Logger logger = Logger.getLogger(JMSUtil.class);

    public static Message receiveMessageOnQueue(String queue, long timeout) {
        AssertArgument.isNotNullAndNotEmpty((String)queue, (String)"queue");
        JMSEpr epr = new JMSEpr("queue", queue, "ConnectionFactory");
        return JMSUtil.receiveMessage(epr, timeout);
    }

    public static Message receiveMessageOnTopic(String topic, long timeout) {
        AssertArgument.isNotNullAndNotEmpty((String)topic, (String)"topic");
        JMSEpr epr = new JMSEpr("topic", topic, "ConnectionFactory");
        return JMSUtil.receiveMessage(epr, timeout);
    }

    public static void sendMessageToQueue(Serializable message, String queue, KeyValuePair[] properties) {
        AssertArgument.isNotNull((Object)message, (String)"message");
        AssertArgument.isNotNullAndNotEmpty((String)queue, (String)"queue");
        JMSEpr epr = new JMSEpr("queue", queue, "ConnectionFactory");
        JMSUtil.deliverMessage(message, epr, properties);
    }

    public static void sendMessageToTopic(Serializable message, String topic, KeyValuePair[] properties) {
        AssertArgument.isNotNull((Object)message, (String)"message");
        AssertArgument.isNotNullAndNotEmpty((String)topic, (String)"topic");
        JMSEpr epr = new JMSEpr("topic", topic, "ConnectionFactory");
        JMSUtil.deliverMessage(message, epr, properties);
    }

    private static Message receiveMessage(JMSEpr epr, long timeout) {
        JmsCourier courier = null;
        JMSUtil.addJndiExtensions(epr);
        try {
            courier = new JmsCourier(epr, true);
        }
        catch (CourierException e) {
            throw new RuntimeException("Failed to create pickup courier for epr '" + epr + "': " + e.getMessage());
        }
        try {
            return courier.pickupPayload(timeout);
        }
        catch (CourierException e) {
            throw new RuntimeException("Failed to pickup message on JMS epr '" + epr + "': " + e.getMessage());
        }
        catch (CourierTimeoutException e) {
            throw new RuntimeException("Failed to pickup message on JMS epr '" + epr + "': " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deliverMessage(Serializable message, JMSEpr epr, KeyValuePair[] properties) {
        String destType = null;
        String destName = null;
        JmsCourier courier = null;
        ObjectMessage jmsMessage = null;
        JMSUtil.addJndiExtensions(epr);
        try {
            destType = epr.getDestinationType();
            destName = epr.getDestinationName();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Totally unexpected exception from a getter method: " + e.getMessage());
        }
        try {
            courier = new JmsCourier(epr);
        }
        catch (CourierException e) {
            throw new RuntimeException("Failed to create JMSCourier to JMS " + destType + " '" + destName + "': " + e.getMessage());
        }
        try {
            try {
                jmsMessage = courier.getJmsSession(epr.getAcknowledgeMode()).createObjectMessage(message);
            }
            catch (CourierException e) {
                throw new RuntimeException("Failed to get JMS Session for sending to JMS " + destType + " '" + destName + "': " + e.getMessage());
            }
            catch (JMSException e) {
                throw new RuntimeException("Failed to create JMS Message for sending to JMS " + destType + " '" + destName + "': " + e.getMessage());
            }
            if (properties != null) {
                try {
                    JMSUtil.setStringProperties((Message)jmsMessage, properties);
                }
                catch (JMSException e) {
                    throw new RuntimeException("Failed to set properties on the JMS Message to JMS " + destType + " '" + destName + "': " + e.getMessage());
                }
            }
            try {
                courier.deliver((Message)jmsMessage);
            }
            catch (CourierException e) {
                throw new RuntimeException("Failed to deliver JMS Message to JMS " + destType + " '" + destName + "': " + e.getMessage());
            }
        }
        finally {
            courier.cleanup();
        }
    }

    private static void addJndiExtensions(JMSEpr epr) {
        epr.getAddr().addExtension("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        epr.getAddr().addExtension("java.naming.provider.url", "localhost");
    }

    private static void setStringProperties(Message msg, KeyValuePair[] properties) throws JMSException {
        if (properties == null) {
            return;
        }
        for (KeyValuePair property : properties) {
            msg.setStringProperty(property.getKey(), property.getValue());
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            throw new RuntimeException("Invalid arg list. 3 args expected. arg1: destName, arg2: destType (queue/topic), arg3: message");
        }
        String destName = args[0];
        String destType = args[1];
        String message = args[2];
        if (destType.equals("queue")) {
            JMSUtil.sendMessageToQueue((Serializable)((Object)message), destName, null);
        } else if (destType.equals("topic")) {
            JMSUtil.sendMessageToTopic((Serializable)((Object)message), destName, null);
        } else {
            throw new RuntimeException("Invalid 2nd arg value for destType. Must be one of 'queue' or 'topic'.");
        }
    }
}

