/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Server;
import org.apache.catalina.util.StringManager;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonMBean;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Constants;
import org.jboss.modcluster.ServerProvider;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.ha.HASingletonAwareResetRequestSource;
import org.jboss.modcluster.ha.rpc.ResetRequestSourceRpcHandler;
import org.jboss.modcluster.ha.rpc.RpcResponse;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingletonAwareResetRequestSourceImpl
extends ResetRequestSourceImpl
implements HASingletonAwareResetRequestSource {
    static final String METHOD_NAME = "getResetRequests";
    static final Class<?>[] TYPES = new Class[]{Map.class};
    private static final Logger log = Logger.getLogger(HASingletonAwareResetRequestSourceImpl.class);
    private final StringManager sm = StringManager.getManager((String)Constants.Package);
    private final HASingletonMBean singleton;
    private final ResetRequestSourceRpcHandler<List<RpcResponse<List<MCMPRequest>>>> rpcStub;

    public HASingletonAwareResetRequestSourceImpl(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, ServerProvider<Server> serverProvider, MCMPRequestFactory requestFactory, HASingletonMBean singleton, HAServiceKeyProvider serviceKeyProvider) {
        super(nodeConfig, balancerConfig, serverProvider, requestFactory);
        this.singleton = singleton;
        this.rpcStub = new RpcStub(serviceKeyProvider);
    }

    @Override
    public List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
        if (this.singleton.isMasterNode()) {
            List<MCMPRequest> resets = this.getLocalResetRequests(response);
            this.addRemoteRequests(resets, response);
            return resets;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MCMPRequest> getLocalResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
        return super.getResetRequests(response);
    }

    private void addRemoteRequests(List<MCMPRequest> resets, Map<String, Set<ResetRequestSource.VirtualHost>> resp) {
        List<RpcResponse<List<MCMPRequest>>> responses = this.rpcStub.getResetRequests(resp);
        for (RpcResponse<List<MCMPRequest>> response : responses) {
            try {
                resets.addAll((Collection<MCMPRequest>)response.getResult());
            }
            catch (RuntimeException e) {
                log.warn((Object)this.sm.getString("modcluster.error.rpc.known", (Object)METHOD_NAME, (Object)response.getSender()), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RpcStub
    implements ResetRequestSourceRpcHandler<List<RpcResponse<List<MCMPRequest>>>> {
        private final HAServiceKeyProvider serviceKeyProvider;

        RpcStub(HAServiceKeyProvider serviceKeyProvider) {
            this.serviceKeyProvider = serviceKeyProvider;
        }

        @Override
        public List<RpcResponse<List<MCMPRequest>>> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
            try {
                return this.serviceKeyProvider.getHAPartition().callMethodOnCluster(this.serviceKeyProvider.getHAServiceKey(), HASingletonAwareResetRequestSourceImpl.METHOD_NAME, new Object[]{response}, (Class[])TYPES, true);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }
    }
}

