/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.agriculture.dag.agorha.business.primes;

import fr.gouv.agriculture.dag.agorha.util.Periode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SousPeriodePrimeAgent {
    private String nomAgent;
    private Periode periode;
    private Short codeCorps;
    private String codeDepartement;
    private Short codeFonction;
    private Integer codeGrade;
    private String codePosition1;
    private String codePosition2;
    private String codePrime;
    private Integer demandeNumeroVersement;
    private String echelle;
    private Integer echelon;
    private Map<String, Boolean> eligibleForMap = new HashMap<String, Boolean>();
    private Long idSousPeriodePrimeAgent;
    private String indicateurTraitementModulationAgent;
    private String indiceBrut;
    private Short indiceMajore;
    private Boolean modulationPermanente;
    private BigDecimal montantBase;
    private BigDecimal montantBudget;
    private BigDecimal montantBudgetMax;
    private BigDecimal montantVersement;
    private boolean montantsOK = false;
    private Integer nbHeuresSemainePrincipale;
    private Integer nbHeuresSemaineSecondaire;
    private Integer numeroAgent;
    private Integer numeroDemande;
    private Integer numeroStructureAdministrative;
    private Integer numeroStructureOperationnelle;
    private Integer primeNbVersements = 12;
    private boolean priseEnCompteMajorationDepartementale = true;
    private boolean priseEnComptePosition = true;
    private BigDecimal quotiteLogement;
    private BigDecimal quotiteMajorationReduction;
    private BigDecimal quotiteModulation;
    private BigDecimal quotiteRemuneration;
    private BigDecimal quotiteStagiaire;
    private BigDecimal quotiteTraitement;
    private String secteurBudgetaire;
    private boolean stagiaire;
    private BigDecimal tauxAgentLoge;
    private BigDecimal tauxMajorationDepartementale;
    private Integer tauxModulation;
    private boolean tauxModulationAgentObligatoire = true;
    private Integer tauxStagiaire;
    private BigDecimal tauxTraitement;
    private Integer tauxTravail;
    private String typeEtablissementOperationnelle;

    public Short getCodeCorps() {
        return this.codeCorps;
    }

    public void setCodeCorps(Short codeCorps) {
        this.codeCorps = codeCorps;
    }

    public String getCodeDepartement() {
        return this.codeDepartement;
    }

    public void setCodeDepartement(String codeDepartement) {
        this.codeDepartement = codeDepartement;
    }

    public Short getCodeFonction() {
        return this.codeFonction;
    }

    public void setCodeFonction(Short codeFonction) {
        this.codeFonction = codeFonction;
    }

    public Integer getCodeGrade() {
        return this.codeGrade;
    }

    public void setCodeGrade(Integer codeGrade) {
        this.codeGrade = codeGrade;
    }

    public String getCodePosition1() {
        return this.codePosition1;
    }

    public void setCodePosition1(String codePosition1) {
        this.codePosition1 = codePosition1;
    }

    public String getCodePosition2() {
        return this.codePosition2;
    }

    public void setCodePosition2(String codePosition2) {
        this.codePosition2 = codePosition2;
    }

    public String getCodePrime() {
        return this.codePrime;
    }

    public void setCodePrime(String codePrime) {
        this.codePrime = codePrime;
    }

    public Integer getDemandeNumeroVersement() {
        return this.demandeNumeroVersement;
    }

    public void setDemandeNumeroVersement(Integer demandeNumeroVersement) {
        this.demandeNumeroVersement = demandeNumeroVersement;
    }

    public String getEchelle() {
        return this.echelle;
    }

    public void setEchelle(String echelle) {
        this.echelle = echelle;
    }

    public Integer getEchelon() {
        return this.echelon;
    }

    public void setEchelon(Integer echelon) {
        this.echelon = echelon;
    }

    public Long getIdSousPeriodePrimeAgent() {
        return this.idSousPeriodePrimeAgent;
    }

    public void setIdSousPeriodePrimeAgent(Long idSousPeriodePrimeAgent) {
        this.idSousPeriodePrimeAgent = idSousPeriodePrimeAgent;
    }

    public String getIndicateurTraitementModulationAgent() {
        return this.indicateurTraitementModulationAgent;
    }

    public void setIndicateurTraitementModulationAgent(String indicateurTraitementModulationAgent) {
        this.indicateurTraitementModulationAgent = indicateurTraitementModulationAgent;
    }

    public String getIndiceBrut() {
        return this.indiceBrut;
    }

    public void setIndiceBrut(String indiceBrut) {
        this.indiceBrut = indiceBrut;
    }

    public Short getIndiceMajore() {
        return this.indiceMajore;
    }

    public void setIndiceMajore(Short indiceMajore) {
        this.indiceMajore = indiceMajore;
    }

    public BigDecimal getMontantBase() {
        return this.montantBase;
    }

    public void setMontantBase(BigDecimal montantBase) {
        this.montantBase = montantBase;
    }

    public BigDecimal getMontantBudget() {
        return this.montantBudget;
    }

    public void setMontantBudget(BigDecimal montantBudget) {
        this.montantBudget = montantBudget;
    }

    public BigDecimal getMontantBudgetMax() {
        return this.montantBudgetMax;
    }

    public void setMontantBudgetMax(BigDecimal montantBudgetMax) {
        this.montantBudgetMax = montantBudgetMax;
    }

    public BigDecimal getMontantVersement() {
        return this.montantVersement;
    }

    public void setMontantVersement(BigDecimal montantVersement) {
        this.montantVersement = montantVersement;
    }

    public Integer getNbHeuresSemainePrincipale() {
        return this.nbHeuresSemainePrincipale;
    }

    public void setNbHeuresSemainePrincipale(Integer nbHeuresSemainePrincipale) {
        this.nbHeuresSemainePrincipale = nbHeuresSemainePrincipale;
    }

    public Integer getNbHeuresSemaineSecondaire() {
        return this.nbHeuresSemaineSecondaire;
    }

    public void setNbHeuresSemaineSecondaire(Integer nbHeuresSemaineSecondaire) {
        this.nbHeuresSemaineSecondaire = nbHeuresSemaineSecondaire;
    }

    public Integer getNumeroAgent() {
        return this.numeroAgent;
    }

    public void setNumeroAgent(Integer numeroAgent) {
        this.numeroAgent = numeroAgent;
    }

    public Integer getNumeroDemande() {
        return this.numeroDemande;
    }

    public void setNumeroDemande(Integer numeroDemande) {
        this.numeroDemande = numeroDemande;
    }

    public Integer getNumeroStructureAdministrative() {
        return this.numeroStructureAdministrative;
    }

    public void setNumeroStructureAdministrative(Integer numeroStructureAdministrative) {
        this.numeroStructureAdministrative = numeroStructureAdministrative;
    }

    public Integer getNumeroStructureOperationnelle() {
        return this.numeroStructureOperationnelle;
    }

    public void setNumeroStructureOperationnelle(Integer numeroStructureOperationnelle) {
        this.numeroStructureOperationnelle = numeroStructureOperationnelle;
    }

    public Periode getPeriode() {
        return this.periode;
    }

    public void setPeriode(Periode periode) {
        this.periode = periode;
    }

    public Integer getPrimeNbVersements() {
        return this.primeNbVersements;
    }

    public void setPrimeNbVersements(Integer primeNbVersements) {
        this.primeNbVersements = primeNbVersements;
    }

    public BigDecimal getQuotiteLogement() {
        return this.quotiteLogement;
    }

    public void setQuotiteLogement(BigDecimal quotiteLogement) {
        this.quotiteLogement = quotiteLogement;
    }

    public BigDecimal getQuotiteMajorationReduction() {
        return this.quotiteMajorationReduction;
    }

    public void setQuotiteMajorationReduction(BigDecimal quotiteMajorationReduction) {
        this.quotiteMajorationReduction = quotiteMajorationReduction;
    }

    public BigDecimal getQuotiteModulation() {
        return this.quotiteModulation;
    }

    public void setQuotiteModulation(BigDecimal quotiteModulation) {
        this.quotiteModulation = quotiteModulation;
    }

    public BigDecimal getQuotiteRemuneration() {
        return this.quotiteRemuneration;
    }

    public void setQuotiteRemuneration(BigDecimal quotiteRemuneration) {
        this.quotiteRemuneration = quotiteRemuneration;
    }

    public BigDecimal getQuotiteStagiaire() {
        return this.quotiteStagiaire;
    }

    public void setQuotiteStagiaire(BigDecimal quotiteStagiaire) {
        this.quotiteStagiaire = quotiteStagiaire;
    }

    public BigDecimal getQuotiteTraitement() {
        return this.quotiteTraitement;
    }

    public void setQuotiteTraitement(BigDecimal quotiteTraitement) {
        this.quotiteTraitement = quotiteTraitement;
    }

    public String getSecteurBudgetaire() {
        return this.secteurBudgetaire;
    }

    public void setSecteurBudgetaire(String secteurBudgetaire) {
        this.secteurBudgetaire = secteurBudgetaire;
    }

    public BigDecimal getTauxAgentLoge() {
        return this.tauxAgentLoge;
    }

    public void setTauxAgentLoge(BigDecimal tauxAgentLoge) {
        this.tauxAgentLoge = tauxAgentLoge;
    }

    public BigDecimal getTauxMajorationDepartementale() {
        return this.tauxMajorationDepartementale;
    }

    public void setTauxMajorationDepartementale(BigDecimal tauxMajorationDepartementale) {
        this.tauxMajorationDepartementale = tauxMajorationDepartementale;
    }

    public Integer getTauxModulation() {
        return this.tauxModulation;
    }

    public void setTauxModulation(Integer tauxModulation) {
        this.tauxModulation = tauxModulation;
    }

    public Integer getTauxStagiaire() {
        return this.tauxStagiaire;
    }

    public void setTauxStagiaire(Integer tauxStagiaire) {
        this.tauxStagiaire = tauxStagiaire;
    }

    public BigDecimal getTauxTraitement() {
        return this.tauxTraitement;
    }

    public void setTauxTraitement(BigDecimal tauxTraitement) {
        this.tauxTraitement = tauxTraitement;
    }

    public Integer getTauxTravail() {
        return this.tauxTravail;
    }

    public void setTauxTravail(Integer tauxTravail) {
        this.tauxTravail = tauxTravail;
    }

    public String getTypeEtablissementOperationnelle() {
        return this.typeEtablissementOperationnelle;
    }

    public void setTypeEtablissementOperationnelle(String typeEtablissementOperationnelle) {
        this.typeEtablissementOperationnelle = typeEtablissementOperationnelle;
    }

    public Boolean isModulationPermanente() {
        return this.modulationPermanente;
    }

    public Boolean getModulationPermanente() {
        return this.modulationPermanente;
    }

    public void setModulationPermanente(Boolean modulationPermanente) {
        this.modulationPermanente = modulationPermanente;
    }

    public boolean isMontantsOK() {
        return this.montantsOK;
    }

    public void setMontantsOK(boolean montantsOK) {
        this.montantsOK = montantsOK;
    }

    public boolean isPriseEnCompteMajorationDepartementale() {
        return this.priseEnCompteMajorationDepartementale;
    }

    public void setPriseEnCompteMajorationDepartementale(boolean priseEnCompteMajorationDepartementale) {
        this.priseEnCompteMajorationDepartementale = priseEnCompteMajorationDepartementale;
    }

    public boolean isPriseEnComptePosition() {
        return this.priseEnComptePosition;
    }

    public void setPriseEnComptePosition(boolean priseEnComptePosition) {
        this.priseEnComptePosition = priseEnComptePosition;
    }

    public boolean isStagiaire() {
        return this.stagiaire;
    }

    public void setStagiaire(boolean stagiaire) {
        this.stagiaire = stagiaire;
    }

    public boolean isTauxModulationAgentObligatoire() {
        return this.tauxModulationAgentObligatoire;
    }

    public void setTauxModulationAgentObligatoire(boolean tauxModulationAgentObligatoire) {
        this.tauxModulationAgentObligatoire = tauxModulationAgentObligatoire;
    }

    public String toString() {
        return "SousPeriodePrimeAgent{codePrime='" + this.codePrime + '\'' + ", agent=" + this.nomAgent + ", periode=" + this.periode + '}';
    }

    public Serializable getIdentifier() {
        return this.idSousPeriodePrimeAgent;
    }

    public Set<String> getEligibleFiltragesAppliques() {
        return this.eligibleForMap.keySet();
    }

    public BigDecimal getRatioDureeComptable() {
        int nbJoursCompatablesSousPeriode = this.getPeriode().getDureeComptable().getNbreJours();
        return BigDecimal.valueOf(nbJoursCompatablesSousPeriode).divide(BigDecimal.valueOf(360L), 10, 6);
    }

    public boolean isEligibleSetFor(String critere) {
        return this.eligibleForMap.containsKey(critere);
    }

    public boolean isIneligible() {
        for (Boolean eligible : this.eligibleForMap.values()) {
            if (eligible.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isVersementCorrespondAuSolde() {
        return this.primeNbVersements != null && this.demandeNumeroVersement != null && this.demandeNumeroVersement >= this.primeNbVersements;
    }

    public boolean modulationPermanenteFasleIfNull() {
        if (this.modulationPermanente == null) {
            return false;
        }
        return this.modulationPermanente;
    }

    public void setEligibleFor(String critere, boolean eligible) {
        this.eligibleForMap.put(critere, eligible);
    }

    public void setModulationPermanenteFromStr(String moduPermStr) {
        if (moduPermStr.equalsIgnoreCase("O") || moduPermStr.equalsIgnoreCase("true")) {
            this.setModulationPermanente(true);
        } else {
            this.setModulationPermanente(false);
        }
    }

    public void setQuotiteLogementFromTaux(String boolStr) {
        if (boolStr.equalsIgnoreCase("O") || boolStr.equalsIgnoreCase("true")) {
            this.setQuotiteLogement(this.getTauxAgentLoge().divide(BigDecimal.valueOf(100L), 10, 6));
        } else {
            this.setQuotiteLogement(BigDecimal.ONE);
        }
    }

    public void setQuotiteMajorationReductionMilliemes(long milliemes) {
        this.setQuotiteMajorationReduction(BigDecimal.valueOf(milliemes).divide(BigDecimal.valueOf(1000L), 3, 6));
    }

    public void setQuotiteModulationFromTauxModulation() {
        this.setQuotiteModulation(BigDecimal.valueOf(this.getTauxModulation().intValue()).divide(BigDecimal.valueOf(100L), 10, 6));
    }

    public void setQuotiteRemuneration(BigDecimal num, BigDecimal den) {
        this.setQuotiteRemuneration(num.divide(den, 10, 6));
    }

    public void setQuotiteStagiaireFromTaux() {
        this.setQuotiteStagiaire(BigDecimal.valueOf(this.getTauxStagiaire().intValue()).divide(BigDecimal.valueOf(100L), 10, 6));
    }

    public void setQuotiteTraitement(BigDecimal num, BigDecimal den) {
        this.setQuotiteTraitement(num.divide(den, 10, 6));
    }

    public void setTauxMajorationDepartementaleMilliemes(long milliemes) {
        this.setTauxMajorationDepartementale(BigDecimal.valueOf(milliemes).divide(BigDecimal.valueOf(1000L), 3, 6));
    }

    public String getNomAgent() {
        return this.nomAgent;
    }

    public void setNomAgent(String nomAgent) {
        this.nomAgent = nomAgent;
    }
}

