/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.HibernateEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.message.Message;

public class HibernateCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    protected HibernateEpr m_epr = null;
    protected static Logger m_Logger = Logger.getLogger(HibernateCourier.class);
    protected Query m_prepDelete = null;
    protected Query m_prepInsert = null;
    protected Query m_prepUpdate = null;
    protected Query m_prepSelUpd = null;
    protected Query m_prepGetList = null;
    private boolean m_isReceiver = false;
    protected long m_pollLatency = 200L;

    private HibernateCourier() {
    }

    HibernateCourier(HibernateEpr epr) throws CourierException {
        this(epr, false);
    }

    public HibernateCourier(HibernateEpr epr, boolean pickUpOnly) {
        this.m_isReceiver = pickUpOnly;
        this.m_epr = epr;
    }

    public void cleanup() {
    }

    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        if (this.m_isReceiver) {
            throw new CourierException("This is a read-only Courier");
        }
        if (null == message) {
            return false;
        }
        Call call = message.getHeader().getCall();
        if (null == call) {
            call = new Call();
            message.getHeader().setCall(call);
        }
        try {
            if (null == call.getMessageID()) {
                call.setMessageID(new URI(UUID.randomUUID().toString()));
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedEPRException("Problems with message header ", e);
        }
        return false;
    }

    public Message pickup(long millis) throws CourierException, CourierTimeoutException {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        Pending,
        WorkInProgress,
        Done,
        Error;


        String getColumnValue() {
            return this.toString().substring(0, 1);
        }
    }
}

