/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.remoting;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.remoting.JBossRemotingUtil;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.soa.esb.http.HttpContentTypeUtil;

public class HttpUnmarshaller
extends SerializableUnMarshaller {
    static final long serialVersionUID = 1085086661310576768L;
    private static final Logger log = Logger.getLogger(HttpUnmarshaller.class);

    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        if (JBossRemotingUtil.receiveJavaObjectPayload(metadata)) {
            try {
                return super.read(inputStream, metadata, version);
            }
            catch (EOFException e) {
                return null;
            }
        }
        int bufferSize = 1024;
        byte[] byteBuffer = new byte[bufferSize];
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        if (metadata != null) {
            Object value = metadata.get("Content-Length");
            if (value == null) {
                value = metadata.get("content-length");
            }
            if (value != null) {
                List valueList;
                if (value instanceof List && (valueList = (List)value) != null && valueList.size() > 0) {
                    value = valueList.get(0);
                }
                if (value instanceof String) {
                    try {
                        Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Error converting Content-Length value (" + value + ") from metadata into int value."));
                    }
                } else {
                    log.warn((Object)"Can not get Content-Length from header for http unmarshalling.");
                }
            }
        }
        int pointer = 0;
        int amtRead = inputStream.read(byteBuffer);
        while (amtRead > 0) {
            byteOutputStream.write(byteBuffer, pointer, amtRead);
            amtRead = inputStream.read(byteBuffer);
        }
        byteOutputStream.flush();
        byte[] totalByteArray = byteOutputStream.toByteArray();
        if (totalByteArray.length == 0) {
            return null;
        }
        String contentType = JBossRemotingUtil.getContentType(metadata);
        if (!HttpContentTypeUtil.isTextMimetype(contentType)) {
            return totalByteArray;
        }
        try {
            return new String(totalByteArray);
        }
        catch (Exception e) {
            log.error((Object)"Can not unmarshall inputstream.  Tried to unmarshall as both an object and string type.", (Throwable)e);
            throw new IOException("Can not unmarshall inputstream.");
        }
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        HttpUnmarshaller unmarshaller = new HttpUnmarshaller();
        unmarshaller.setClassLoader(this.customClassLoader);
        return unmarshaller;
    }

    private boolean isErrorReturn(Map metadata) {
        int responseCode;
        Object value;
        boolean isError = false;
        if (metadata != null && (value = metadata.get("ResponseCode")) != null && value instanceof Integer && (responseCode = ((Integer)value).intValue()) > 400) {
            isError = true;
        }
        return isError;
    }
}

