/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.templating;

import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class StringTemplateProcessor
extends AbstractActionPipelineProcessor {
    private StringTemplate template;
    private MessagePayloadProxy payloadProxy;

    public StringTemplateProcessor(ConfigTree config) {
        String path = config.getAttribute("template");
        String encoding = config.getAttribute("encoding", "UTF-8");
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith(".st")) {
            path = path.substring(0, path.length() - 3);
        }
        StringTemplateGroup templateGroup = new StringTemplateGroup(path);
        templateGroup.setFileCharEncoding(encoding);
        this.template = templateGroup.getInstanceOf(path);
        this.payloadProxy = new MessagePayloadProxy(config);
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
    }

    public Message process(Message message) throws ActionProcessingException {
        Map beans;
        StringTemplate thisTransTemplate = this.template.getInstanceOf();
        try {
            beans = (Map)this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        thisTransTemplate.setAttributes(beans);
        try {
            this.payloadProxy.setPayload(message, thisTransTemplate.toString());
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }
}

