/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SourceFactory {
    private static final SourceFactory factory = new SourceFactory();

    private SourceFactory() {
    }

    public static SourceFactory getInstance() {
        return factory;
    }

    public Source createSource(Object from) {
        Source source;
        if (from instanceof String) {
            source = new StreamSource(new StringReader((String)from));
        } else if (from instanceof byte[]) {
            source = new StreamSource(new ByteArrayInputStream((byte[])from));
        } else if (from instanceof Reader) {
            source = new StreamSource((Reader)from);
        } else if (from instanceof InputStream) {
            source = new StreamSource((InputStream)from);
        } else if (from instanceof File) {
            source = this.fileSource((File)from);
        } else if (from instanceof Source) {
            source = (Source)from;
        } else {
            throw new IllegalStateException("Object '" + from + "' is not of a supported type (String, byte[], Reader, InputStream, File, or Source). Try using a SourceResult instead perhaps.");
        }
        return source;
    }

    private Source fileSource(File file) {
        try {
            return new StreamSource(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

