/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.URIResolver;
import org.jboss.soa.esb.actions.transformation.xslt.ResultFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerFactoryConfig {
    private final String templateFile;
    private final ResultFactory.ResultType resultType;
    private final Map<String, Boolean> features;
    private final Map<String, Object> attributes;
    private URIResolver uriResolver;

    private TransformerFactoryConfig(Builder builder) {
        this.templateFile = builder.templateFile;
        this.features = builder.features;
        this.attributes = builder.attributes;
        this.uriResolver = builder.uriResolver;
        this.resultType = builder.resultType;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public ResultFactory.ResultType getResultType() {
        return this.resultType;
    }

    public static class Builder {
        private final String templateFile;
        private Map<String, Boolean> features;
        private Map<String, Object> attributes;
        private URIResolver uriResolver;
        private ResultFactory.ResultType resultType;

        public Builder(String templateFile) {
            this.templateFile = templateFile;
        }

        public Builder feature(String name, Boolean value) {
            if (this.features == null) {
                this.features = new HashMap<String, Boolean>();
            }
            this.features.put(name, value);
            return this;
        }

        public Builder attribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public Builder uriResolver(URIResolver resolver) {
            this.uriResolver = resolver;
            return this;
        }

        public Builder resultType(ResultFactory.ResultType type) {
            this.resultType = type;
            return this;
        }

        public TransformerFactoryConfig build() {
            if (this.features == null) {
                this.features = Collections.emptyMap();
            }
            if (this.attributes == null) {
                this.attributes = Collections.emptyMap();
            }
            if (this.resultType == null) {
                this.resultType = ResultFactory.ResultType.STRING;
            }
            return new TransformerFactoryConfig(this);
        }
    }
}

