/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.util;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultFileReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultFtpReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultFtpsReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultHibernateReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultInVMReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultJdbcReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultJmsReplyToEpr;
import org.jboss.internal.soa.esb.addressing.eprs.DefaultSftpReplyToEpr;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.addressing.eprs.HibernateEpr;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.message.Message;

public class DefaultReplyTo {
    public static EPR getReplyTo(EPR toEpr) throws CourierException, MalformedEPRException {
        try {
            if (null == toEpr) {
                throw new IllegalArgumentException("toEpr must not be null");
            }
            if (toEpr instanceof InVMEpr) {
                return new DefaultInVMReplyToEpr((InVMEpr)toEpr);
            }
            if (toEpr instanceof JMSEpr) {
                return new DefaultJmsReplyToEpr((JMSEpr)toEpr);
            }
            if (toEpr instanceof FTPSEpr) {
                return new DefaultFtpsReplyToEpr((FTPSEpr)toEpr);
            }
            if (toEpr instanceof SFTPEpr) {
                return new DefaultSftpReplyToEpr((SFTPEpr)toEpr);
            }
            if (toEpr instanceof FTPEpr) {
                return new DefaultFtpReplyToEpr((FTPEpr)toEpr);
            }
            if (toEpr instanceof FileEpr) {
                return new DefaultFileReplyToEpr((FileEpr)toEpr);
            }
            if (toEpr instanceof JDBCEpr) {
                return new DefaultJdbcReplyToEpr((JDBCEpr)toEpr);
            }
            if (toEpr instanceof HibernateEpr) {
                return new DefaultHibernateReplyToEpr((HibernateEpr)toEpr);
            }
        }
        catch (MalformedURLException ex) {
            throw new MalformedEPRException(ex);
        }
        catch (URISyntaxException ex) {
            throw new MalformedEPRException(ex);
        }
        throw new CourierException("Unsupported default reply to EPR " + toEpr.getClass().getSimpleName());
    }

    public static boolean initialiseReply(Message message, Call callDetails) {
        return DefaultReplyTo.initialiseReply(message, callDetails, DefaultReplyTo.getReplyTo(callDetails));
    }

    static EPR getReplyTo(Call callDetails) {
        if (callDetails == null) {
            return null;
        }
        EPR replyTo = callDetails.getReplyTo();
        if (replyTo != null) {
            return replyTo;
        }
        return callDetails.getFrom();
    }

    static boolean initialiseReply(Message message, Call callDetails, EPR toEPR) {
        if (message == null || callDetails == null || toEPR == null) {
            return false;
        }
        Call replyCallDetails = message.getHeader().getCall();
        replyCallDetails.setTo(toEPR);
        replyCallDetails.setFrom(callDetails.getTo());
        replyCallDetails.setReplyTo(null);
        replyCallDetails.setFaultTo(null);
        replyCallDetails.setRelatesTo(callDetails.getMessageID());
        replyCallDetails.setMessageID(null);
        return true;
    }
}

