/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigTree
implements Serializable,
Cloneable {
    private static Logger logger = Logger.getLogger(ConfigTree.class);
    private static final long serialVersionUID = 1L;
    private boolean _pureText = true;
    private ConfigTree _dad;
    private String _name;
    private Map<String, String> _attributes;
    private List<Child> _childs;
    private static transient Logger _logger = Logger.getLogger(ConfigTree.class);

    public ConfigTree(String name) {
        this(name, null);
    }

    public ConfigTree(String name, ConfigTree dad) {
        this.setName(name);
        this.setParent(dad);
    }

    protected ConfigTree(ConfigTree other) {
        this.copyFrom(other);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public ConfigTree getParent() {
        return this._dad;
    }

    private void setParent(ConfigTree dad) {
        if (null != this._dad) {
            this._dad.removeChild(this);
        }
        if (null != dad) {
            dad.addChild(this);
        }
    }

    public String setAttribute(String name, String value) {
        if (null == name) {
            throw new IllegalArgumentException("Attribute name must be non null");
        }
        if (null == this._attributes) {
            this._attributes = new HashMap<String, String>();
        }
        String oldVal = this._attributes.remove(name);
        if (null != value) {
            this._attributes.put(name, value);
        }
        return oldVal;
    }

    public int attributeCount() {
        return null == this._attributes ? 0 : this._attributes.size();
    }

    public String getAttribute(String name) {
        return null == this._attributes ? null : this._attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String ret = null == this._attributes ? null : this._attributes.get(name);
        return ret != null ? ret : defaultValue;
    }

    public long getLongAttribute(String name, long defaultValue) {
        String value = this.getAttribute(name);
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Invalid value '" + value + "' for property '" + name + "'.  Must be an long/integer value.  Returning default value '" + defaultValue + "'."));
            }
        }
        return defaultValue;
    }

    public float getFloatAttribute(String name, float defaultValue) {
        String value = this.getAttribute(name);
        if (value != null) {
            try {
                return Float.parseFloat(value.trim());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Invalid value '" + value + "' for property '" + name + "'.  Must be an float value.  Returning default value '" + defaultValue + "'."));
            }
        }
        return defaultValue;
    }

    public boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value.trim());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Invalid value '" + value + "' for property '" + name + "'.  Must be an boolean value.  Returning default value '" + defaultValue + "'."));
            }
        }
        return defaultValue;
    }

    public String getRequiredAttribute(String name) throws ConfigurationException {
        String ret = this.getAttribute(name);
        if (ret == null) {
            throw new ConfigurationException("Required configuration property '" + name + "' not defined on configuration '" + this._name + "'.");
        }
        return ret;
    }

    public Set<String> getAttributeNames() {
        return null == this._attributes ? new HashSet() : this._attributes.keySet();
    }

    public List<KeyValuePair> attributesAsList() {
        ArrayList<KeyValuePair> oRet = new ArrayList<KeyValuePair>();
        if (null != this._attributes) {
            for (Map.Entry<String, String> oCurr : this._attributes.entrySet()) {
                oRet.add(new KeyValuePair(oCurr.getKey(), oCurr.getValue()));
            }
        }
        return oRet;
    }

    public List<KeyValuePair> childPropertyList() {
        ArrayList<KeyValuePair> oRet = new ArrayList<KeyValuePair>();
        for (ConfigTree current : this.getChildren("property")) {
            String name = current.getAttribute("name");
            if (null == name) continue;
            oRet.add(new KeyValuePair(name, current.getAttribute("value")));
        }
        return oRet;
    }

    public String getWholeText() {
        if (null == this._childs) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Child child : this._childs) {
            if (!(child._obj instanceof String)) continue;
            sb.append((String)child._obj);
        }
        return sb.toString();
    }

    public String getFirstTextChild(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        if (null != this._childs) {
            for (Child oCurr : this._childs) {
                ConfigTree tree = oCurr.getTree();
                if (null == tree || !tree.isPureText() || !name.equals(tree.getName())) continue;
                return tree.getWholeText();
            }
        }
        return null;
    }

    public String[] getTextChildren(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        if (null == this._childs) {
            return new String[0];
        }
        ArrayList<String> oRet = new ArrayList<String>();
        for (Child oCurr : this._childs) {
            ConfigTree tree = oCurr.getTree();
            if (null == tree || !tree.isPureText() || !name.equals(tree.getName())) continue;
            oRet.add(tree.getWholeText());
        }
        return oRet.toArray(new String[oRet.size()]);
    }

    public void addTextChild(String value) {
        new Child(value);
    }

    private void addChild(ConfigTree child) {
        child._dad = this;
        new Child(child);
    }

    private void removeChild(ConfigTree child) {
        if (this._childs != null) {
            Iterator<Child> childIter = this._childs.iterator();
            while (childIter.hasNext()) {
                if (this != childIter.next()._obj) continue;
                childIter.remove();
                break;
            }
        }
    }

    public ConfigTree[] getAllChildren() {
        if (null == this._childs) {
            return new ConfigTree[0];
        }
        ArrayList<ConfigTree> oRet = new ArrayList<ConfigTree>();
        for (Child oCurr : this._childs) {
            if (null == oCurr.getTree()) continue;
            oRet.add(oCurr.getTree());
        }
        return oRet.toArray(new ConfigTree[oRet.size()]);
    }

    public ConfigTree[] getChildren(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        if (null == this._childs) {
            return new ConfigTree[0];
        }
        ArrayList<ConfigTree> oRet = new ArrayList<ConfigTree>();
        for (Child oCurr : this._childs) {
            if (!name.equals(oCurr.getName())) continue;
            oRet.add(oCurr.getTree());
        }
        return oRet.toArray(new ConfigTree[oRet.size()]);
    }

    public ConfigTree getFirstChild(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        if (null != this._childs) {
            for (Child oCurr : this._childs) {
                if (!name.equals(oCurr.getName())) continue;
                return oCurr.getTree();
            }
        }
        return null;
    }

    public void removeAllChildren() {
        this._childs = null;
    }

    public void removeChildrenByName(String name) {
        if (null == name) {
            throw new IllegalArgumentException();
        }
        if (null != this._childs) {
            ListIterator<Child> II = this._childs.listIterator();
            while (II.hasNext()) {
                if (!name.equals(II.next().getName())) continue;
                II.remove();
            }
        }
    }

    public int childCount() {
        return null == this._childs ? 0 : this._childs.size();
    }

    public Object clone() {
        return this.cloneObj();
    }

    public ConfigTree cloneObj() {
        return this.cloneSubtree(null);
    }

    private ConfigTree cloneSubtree(ConfigTree dad) {
        ConfigTree oRet = new ConfigTree(this._name, dad);
        if (null != this._attributes) {
            for (Map.Entry entry : this._attributes.entrySet()) {
                oRet.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (null != this._childs) {
            for (Child child : this._childs) {
                ConfigTree tree = child.getTree();
                if (null != tree) {
                    tree.cloneSubtree(oRet);
                    continue;
                }
                oRet.addTextChild(child._obj.toString());
            }
        }
        return oRet;
    }

    protected void copyFrom(ConfigTree other) {
        this.setName(other.getName());
        this._pureText = other._pureText;
        if (null != other._attributes) {
            for (Map.Entry entry : other._attributes.entrySet()) {
                this.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (null != other._childs) {
            for (Child child : other._childs) {
                new Child(child);
            }
        }
    }

    public static ConfigTree fromXml(String xml) throws SAXException {
        try {
            return ConfigTree.fromXml(xml, Charset.defaultCharset().toString());
        }
        catch (UnsupportedEncodingException e) {
            _logger.fatal((Object)"Received unexpected exception: ", (Throwable)e);
            return null;
        }
    }

    public static ConfigTree fromXml(String xml, String encoding) throws UnsupportedEncodingException, SAXException {
        if (null == xml) {
            throw new IllegalArgumentException("Xml source String is null");
        }
        try {
            return ConfigTree.fromInputStream(new ByteArrayInputStream(xml.getBytes(encoding)));
        }
        catch (IOException e) {
            _logger.fatal((Object)"Received unexpected IOException: ", (Throwable)e);
            return null;
        }
    }

    public static ConfigTree fromInputStream(InputStream input) throws SAXException, IOException {
        if (null == input) {
            throw new IllegalArgumentException();
        }
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            _logger.error((Object)"Problems with default Parser Configuration", (Throwable)e2);
            return null;
        }
        Document oDoc = builder.parse(input);
        oDoc.normalize();
        return ConfigTree.fromElement(oDoc.getDocumentElement());
    }

    public static ConfigTree fromElement(Element elem) {
        NodeList NL;
        ConfigTree tree = new ConfigTree(elem.getNodeName());
        NamedNodeMap NM = elem.getAttributes();
        if (null != NM) {
            for (int i1 = 0; i1 < NM.getLength(); ++i1) {
                Node node = NM.item(i1);
                tree.setAttribute(node.getNodeName(), node.getNodeValue());
            }
        }
        if (null != (NL = elem.getChildNodes())) {
            block5: for (int i1 = 0; i1 < NL.getLength(); ++i1) {
                Node node = NL.item(i1);
                switch (node.getNodeType()) {
                    case 1: {
                        tree.addChild(ConfigTree.fromElement((Element)node));
                        continue block5;
                    }
                    case 3: {
                        tree.addTextChild(node.getNodeValue());
                    }
                }
            }
        }
        return tree;
    }

    private Element toElement(Document doc) {
        Element elem = doc.createElement(this._name);
        if (null != this._attributes) {
            for (Map.Entry entry : this._attributes.entrySet()) {
                elem.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (null != this._childs) {
            for (Child child : this._childs) {
                ConfigTree tree = child.getTree();
                if (null != tree) {
                    elem.appendChild(tree.toElement(doc));
                    continue;
                }
                elem.appendChild(doc.createTextNode(child._obj.toString()));
            }
        }
        return elem;
    }

    public String toString() {
        return this.toXml();
    }

    public String toString(String encoding) {
        return this.toXml(encoding);
    }

    public String toXml() {
        return this.toXml(Charset.defaultCharset().toString());
    }

    public String toXml(String encoding) {
        Transformer transf = null;
        try {
            transf = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            _logger.error((Object)"Cannot obtain transformer to render XML output", (Throwable)e1);
            return null;
        }
        transf.setOutputProperty("omit-xml-declaration", "yes");
        transf.setOutputProperty("indent", "no");
        transf.setOutputProperty("encoding", encoding);
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            _logger.error((Object)"Problems with default Parser Configuration", (Throwable)e2);
            return null;
        }
        Document oDoc = builder.newDocument();
        oDoc.appendChild(this.toElement(oDoc));
        oDoc.normalize();
        DOMSource src = new DOMSource(oDoc);
        ByteArrayOutputStream oStrm = new ByteArrayOutputStream(5000);
        StreamResult res = new StreamResult(oStrm);
        try {
            transf.transform(src, res);
        }
        catch (TransformerException e3) {
            _logger.error((Object)"Problems with XML transformation", (Throwable)e3);
            return null;
        }
        return oStrm.toString();
    }

    public void mapTo(Map map, String attribute) {
        this.mapTo(map, attribute, attribute);
    }

    public void mapTo(Map map, String from, String to) {
        AssertArgument.isNotNull(map, "properties");
        AssertArgument.isNotNull(from, "from");
        AssertArgument.isNotNull(to, "to");
        String value = this.getAttribute(from);
        if (value != null) {
            map.put(to, value);
        }
    }

    public boolean isPureText() {
        return this._pureText;
    }

    private class Child {
        Object _obj;

        ConfigTree getTree() {
            return this._obj instanceof ConfigTree ? (ConfigTree)this._obj : null;
        }

        String getName() {
            return this._obj instanceof ConfigTree ? ((ConfigTree)this._obj)._name : null;
        }

        private Child(ConfigTree obj) {
            this.addToDad(obj);
            ConfigTree.this._pureText = false;
        }

        private Child(String obj) {
            this.addToDad(obj);
        }

        private Child(Child other) {
            if (other._obj instanceof ConfigTree) {
                this.addToDad(((ConfigTree)other._obj).cloneObj());
                ConfigTree.this._pureText = false;
                return;
            }
            if (other._obj instanceof String) {
                this.addToDad((String)other._obj);
                return;
            }
        }

        private void addToDad(Object obj) {
            if (null == ConfigTree.this._childs) {
                ConfigTree.this._childs = new ArrayList();
            }
            this._obj = obj;
            ConfigTree.this._childs.add(this);
        }
    }
}

