/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers.persist;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.persist.JdbcCleanConn;
import org.jboss.soa.esb.helpers.persist.SqlField;
import org.jboss.soa.esb.util.ClassUtil;

public abstract class SqlDbTable {
    protected String m_sTableName;
    protected SqlField[] m_oaFields;
    protected PreparedStatement[] m_oaPS;
    private JdbcCleanConn m_oConn;
    private String m_sInsertSql;
    private String m_sUpdateSql;
    private String m_sDeleteSql;
    protected String m_sSelectSql;

    public JdbcCleanConn getConn() {
        return this.m_oConn;
    }

    public final String getTableName() {
        return this.m_sTableName;
    }

    public final SqlField[] getAllFields() {
        return this.m_oaFields;
    }

    public SqlDbTable(JdbcCleanConn p_oC, String p_sTblNm) throws SQLException, ConfigurationException {
        this.m_oConn = p_oC;
        this.m_sTableName = p_sTblNm;
        this.initFields();
    }

    public abstract int setInsValues(PreparedStatement var1, Object var2) throws SQLException;

    public abstract Object getFromRS(ResultSet var1) throws SQLException;

    protected abstract String getSelectFields();

    public String getFldName(int p_i) {
        return null == this.m_oaFields ? null : (p_i < 0 ? null : (p_i >= this.m_oaFields.length ? null : this.m_oaFields[p_i].getFieldName()));
    }

    public String getSelectStatement() {
        if (this.m_sSelectSql != null) {
            return this.m_sSelectSql;
        }
        StringBuffer sb = new StringBuffer("select ").append(this.getSelectFields());
        this.m_sSelectSql = sb.append(" from ").append(this.getTableName()).toString();
        return this.m_sSelectSql;
    }

    public String getInsertStatement() {
        if (this.m_sInsertSql != null) {
            return this.m_sInsertSql;
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append("insert into ").append(this.getTableName());
        sb.append(" values (");
        for (int i = 0; i < this.m_oaFields.length; ++i) {
            (i < 1 ? sb : sb.append(",")).append('?');
        }
        sb.append(')');
        this.m_sInsertSql = sb.toString();
        return this.m_sInsertSql;
    }

    public String getUpdateStatement() {
        if (this.m_sUpdateSql != null) {
            return this.m_sUpdateSql;
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append("update ").append(this.getTableName()).append(" set ");
        StringBuffer sbWhere = new StringBuffer(" where ");
        int iVal = 0;
        int iWh = 0;
        for (int i = 0; i < this.m_oaFields.length; ++i) {
            SqlField oCurr = this.m_oaFields[i];
            if (oCurr.isPrimaryKey()) {
                (iWh++ < 1 ? sbWhere : sbWhere.append(" and ")).append(oCurr.getFieldName()).append(" = ?");
                continue;
            }
            (iVal++ < 1 ? sb : sb.append(",")).append(oCurr.getFieldName()).append(" = ?");
        }
        sb.append(sbWhere);
        this.m_sUpdateSql = sb.toString();
        return this.m_sUpdateSql;
    }

    public String getDeleteStatement() {
        if (this.m_sDeleteSql != null) {
            return this.m_sDeleteSql;
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append("delete from ").append(this.getTableName()).append(" where ");
        int iWh = 0;
        for (int i = 0; i < this.m_oaFields.length; ++i) {
            SqlField oCurr = this.m_oaFields[i];
            if (!oCurr.isPrimaryKey()) continue;
            (iWh++ < 1 ? sb : sb.append(" and ")).append(oCurr.getFieldName()).append(" = ?");
        }
        this.m_sDeleteSql = sb.toString();
        return this.m_sDeleteSql;
    }

    public void setObject(PreparedStatement p_PS, int p_iFld, Object p_sFldVal) throws SQLException {
        if (null != p_sFldVal && p_sFldVal instanceof String) {
            String sTr = ((String)p_sFldVal).trim();
            p_sFldVal = sTr.length() > 0 ? sTr : null;
        }
        int iSqlIdx = 1 + p_iFld;
        if (null == p_sFldVal) {
            p_PS.setNull(iSqlIdx, this.m_oaFields[p_iFld].getSqlType());
        } else {
            p_PS.setObject(iSqlIdx, p_sFldVal);
        }
    }

    public void setLong(PreparedStatement p_PS, int p_iFld, long p_lVal) throws SQLException {
        p_PS.setLong(1 + p_iFld, p_lVal);
    }

    public void setInt(PreparedStatement p_PS, int p_iFld, int p_iVal) throws SQLException {
        p_PS.setInt(1 + p_iFld, p_iVal);
    }

    private void initFields() throws SQLException, ConfigurationException {
        PreparedStatement PS = this.m_oConn.prepareStatement(this.getSelectStatement());
        ResultSetMetaData MD = this.m_oConn.execQueryWait(PS, 3).getMetaData();
        this.m_oaFields = new SqlField[MD.getColumnCount()];
        try {
            for (int i1 = 0; i1 < this.m_oaFields.length; ++i1) {
                int iCol = 1 + i1;
                String sFN = MD.getColumnName(iCol);
                Class oCL = ClassUtil.forName(MD.getColumnClassName(iCol), this.getClass());
                int iTP = MD.getColumnType(iCol);
                int iSZ = MD.getColumnDisplaySize(iCol);
                this.m_oaFields[i1] = new SqlField(sFN, oCL, iTP, iSZ, false);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException(ex);
        }
        PS.close();
    }
}

