/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FtpBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FtpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FtpMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.FtpProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel101.Listener;
import org.jboss.soa.esb.listeners.gateway.ReadOnlyRemoteGatewayListener;
import org.jboss.soa.esb.listeners.gateway.RemoteGatewayListener;
import org.w3c.dom.Element;

public class FtpListenerMapper {
    private static final String FTP_SEPARATOR = "/";

    public static Element map(Element root, FtpListenerDocument.FtpListener listener, XMLBeansModel model) throws ConfigurationException {
        FtpProviderDocument.FtpProvider provider;
        FtpBusDocument.FtpBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (FtpBusDocument.FtpBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <ftp-listener> must reference a <ftp-bus>.");
        }
        try {
            provider = (FtpProviderDocument.FtpProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <ftp-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        FtpMessageFilterDocument.FtpMessageFilter messageFilter = listener.getFtpMessageFilter();
        if (messageFilter == null && (messageFilter = bus.getFtpMessageFilter()) == null) {
            throw new ConfigurationException("No <ftp-detination> defined on either <ftp-listener> [" + listener.getName() + "] or <ftp-bus> [" + bus.getBusid() + "].");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            if (messageFilter.getReadOnly()) {
                listenerNode.setAttribute("gatewayClass", ReadOnlyRemoteGatewayListener.class.getName());
            } else {
                listenerNode.setAttribute("gatewayClass", RemoteGatewayListener.class.getName());
            }
            FtpListenerMapper.mapFtpEprProperties(listenerNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            FtpListenerMapper.mapFtpEprProperties(eprNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapFtpEprProperties(Element toElement, FtpProviderDocument.FtpProvider provider, FtpMessageFilterDocument.FtpMessageFilter messageFilter) throws ConfigurationException {
        URI uri;
        int port;
        String hostname;
        String inputDir = messageFilter.getDirectory();
        if (!inputDir.startsWith(FTP_SEPARATOR)) {
            inputDir = FTP_SEPARATOR + inputDir;
        }
        String filterPassword = messageFilter.getPassword();
        String username = FtpListenerMapper.encodeUsername(messageFilter.getUsername());
        String userInfo = filterPassword == null ? username : username + ":" + filterPassword;
        String origHostname = provider.getHostname();
        int colonLocation = origHostname.indexOf(58);
        if (colonLocation > -1) {
            hostname = origHostname.substring(0, colonLocation);
            int portLocation = colonLocation + 1;
            if (portLocation < origHostname.length()) {
                try {
                    port = Integer.parseInt(origHostname.substring(portLocation));
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigurationException("Failed to parse port value");
                }
            } else {
                port = -1;
            }
        } else {
            hostname = origHostname;
            port = -1;
        }
        try {
            uri = new URI(messageFilter.getProtocol().toString(), userInfo, hostname, port, inputDir, null, null);
        }
        catch (URISyntaxException urise) {
            throw new ConfigurationException("Unexpected exception creating FTP URI, " + urise.getMessage());
        }
        toElement.setAttribute("URL", uri.toASCIIString());
        toElement.setAttribute("inputSuffix", messageFilter.getInputSuffix());
        toElement.setAttribute("workSuffix", messageFilter.getWorkSuffix());
        toElement.setAttribute("postDelete", String.valueOf(messageFilter.getPostDelete()));
        if (!messageFilter.getPostDelete()) {
            toElement.setAttribute("postDir", messageFilter.getPostDirectory());
            toElement.setAttribute("postSuffix", messageFilter.getPostSuffix());
        }
        toElement.setAttribute("errorDelete", String.valueOf(messageFilter.getErrorDelete()));
        if (!messageFilter.getErrorDelete()) {
            toElement.setAttribute("errorDir", messageFilter.getErrorDirectory());
            toElement.setAttribute("errorSuffix", messageFilter.getErrorSuffix());
        }
        toElement.setAttribute("passive", String.valueOf(messageFilter.getPassive()));
        if (FtpMessageFilterDocument.FtpMessageFilter.Protocol.SFTP.equals(messageFilter.getProtocol())) {
            toElement.setAttribute("certificate", messageFilter.getCertificateUrl());
            toElement.setAttribute("passphrase", messageFilter.getCertificatePassphrase());
        }
        if (FtpMessageFilterDocument.FtpMessageFilter.Protocol.FTPS.equals(messageFilter.getProtocol())) {
            toElement.setAttribute("certificate", messageFilter.getCertificateUrl());
            toElement.setAttribute("certificateName", messageFilter.getCertificateName());
        }
    }

    private static String encodeUsername(String username) {
        int colonPosn;
        if (username != null && (colonPosn = username.indexOf(58)) > -1) {
            int currentIndex = 0;
            StringBuilder sb = new StringBuilder();
            while (colonPosn > 0) {
                sb.append(username.substring(currentIndex, colonPosn));
                sb.append("%3A");
                currentIndex = colonPosn + 1;
                colonPosn = username.indexOf(58, currentIndex);
            }
            if (currentIndex < username.length()) {
                sb.append(username.substring(currentIndex));
            }
            return sb.toString();
        }
        return username;
    }
}

