/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.mappers120.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers120.XMLBeansModel;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.DualListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.impl.BusImpl;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.impl.BusProviderImpl;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.impl.DualListenerImpl;
import org.w3c.dom.Element;

public class UntypedListenerMapper {
    public static Element map(Element root, DualListener listener, XMLBeansModel model) throws ConfigurationException {
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        UntypedListenerMapper.assertListenerConfigOK((Listener)listener, model);
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            listenerNode.setAttribute("is-gateway", Boolean.toString(listener.getIsGateway()));
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void assertListenerConfigOK(Listener listener, XMLBeansModel model) throws ConfigurationException {
        if (listener.getClass() != DualListenerImpl.class) {
            throw new ConfigurationException("Can only use the " + UntypedListenerMapper.class.getName() + " mapper on the base listener type.  Cannot use on " + listener.getClass().getName());
        }
        Bus bus = model.getBus(listener.getBusidref());
        if (bus.getClass() != BusImpl.class) {
            throw new ConfigurationException("The base Listener config [" + listener.getName() + "] must reference a base Bus config type (<bus>).");
        }
        Provider provider = model.getProvider(bus);
        if (provider.getClass().isAssignableFrom(BusProviderImpl.class)) {
            throw new ConfigurationException("A base Bus config type (<bus>) must be contained within a base Provider type (<bus-provider>).");
        }
    }
}

