/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.model;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.listeners.config.model.Model101SchemaParser;
import org.jboss.soa.esb.listeners.config.model.Model110SchemaParser;
import org.jboss.soa.esb.listeners.config.model.Model120SchemaParser;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.config.model.ModelException;
import org.jboss.soa.esb.listeners.config.model.SchemaParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModelParser {
    private static final Map<String, SchemaParser> SCHEMA_PARSERS = new HashMap<String, SchemaParser>();
    private static final ModelParser PARSER = new ModelParser();
    private static Schema SCHEMA;
    private static Logger LOG;

    public static ModelParser getParser() {
        return PARSER;
    }

    public ModelAdapter parse(Reader config) throws ModelException {
        XMLStreamReader reader;
        try {
            reader = XMLHelper.getXMLStreamReader(config);
            StreamHelper.skipToStartElement(reader);
        }
        catch (XMLStreamException xmlse) {
            throw new ModelException("Error parsing schema", xmlse);
        }
        QName name = reader.getName();
        String namespace = name.getNamespaceURI();
        SchemaParser parser = SCHEMA_PARSERS.get(namespace);
        if (parser != null) {
            return parser.parse(reader);
        }
        throw new ModelException("Unsupported schema namespace: " + namespace);
    }

    public boolean validate(Reader config) {
        if (SCHEMA == null) {
            return true;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setSchema(SCHEMA);
            DocumentBuilder parser = builderFactory.newDocumentBuilder();
            XmlErrorHandler errorHandler = new XmlErrorHandler();
            parser.setErrorHandler(errorHandler);
            parser.parse(new InputSource(config));
            return errorHandler.isValid();
        }
        catch (Exception ex) {
            LOG.error((Object)"Unexpected exception", (Throwable)ex);
            return false;
        }
    }

    static {
        LOG = Logger.getLogger(XmlErrorHandler.class);
        SCHEMA_PARSERS.put("http://anonsvn.labs.jboss.com/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-1.0.1.xsd", new Model101SchemaParser());
        SCHEMA_PARSERS.put("http://anonsvn.labs.jboss.com/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-1.1.0.xsd", new Model110SchemaParser());
        SCHEMA_PARSERS.put("http://anonsvn.labs.jboss.com/labs/jbossesb/trunk/product/etc/schemas/xml/jbossesb-1.2.0.xsd", new Model120SchemaParser());
        Schema schema = null;
        try {
            schema = XMLHelper.getSchema(new String[]{"/jbossesb-1.0.1.xsd", "/jbossesb-1.1.0.xsd", "/jbossesb-1.2.0.xsd"});
        }
        catch (SAXException saxe) {
            LOG.warn((Object)"Unexpected exception loading schemas", (Throwable)saxe);
        }
        SCHEMA = schema;
    }

    private static class XmlErrorHandler
    implements ErrorHandler {
        private boolean valid = true;

        private XmlErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn((Object)("WARNING-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
        }

        public void error(SAXParseException exception) throws SAXException {
            LOG.error((Object)("ERROR-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
            this.valid = false;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.fatal((Object)("FATAL-" + exception.getSystemId() + "-" + exception.getLineNumber() + ":" + exception.getMessage()));
            this.valid = false;
        }

        boolean isValid() {
            return this.valid;
        }
    }
}

