/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.gateway.HttpMessageComposer;
import org.jboss.soa.esb.listeners.gateway.http.HttpRequestWrapper;
import org.jboss.soa.esb.listeners.message.UncomposedMessageDeliveryAdapter;
import org.jboss.soa.esb.message.Message;

public class HttpDispatchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private boolean synchronous = true;
    private String asyncResponse = null;
    private int serviceTimeout = 20000;
    private String allowHttpMethods = "POST,GET";
    private ConfigTree config;
    public transient UncomposedMessageDeliveryAdapter messageDeliveryAdapter;

    public void init() throws ServletException {
        this.config = (ConfigTree)this.getServletContext().getAttribute("config");
        this.synchronous = !this.config.getAttribute("synchronous", "true").equalsIgnoreCase("false");
        this.serviceTimeout = Integer.parseInt(this.config.getAttribute("serviceTimeout", "20000"));
        this.asyncResponse = this.config.getAttribute("asyncResponse");
        if (this.config.getAttribute("allowHttpMethod") != null) {
            this.allowHttpMethods = this.config.getAttribute("allowHttpMethod").toUpperCase();
        }
        try {
            this.initTransient();
        }
        catch (ConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void serveRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        if (!"/".equals(servletPath)) {
            response.setStatus(404);
            return;
        }
        HttpRequestWrapper wrapper = new HttpRequestWrapper(request, response, null);
        try {
            if (this.synchronous) {
                this.messageDeliveryAdapter.deliverSync(wrapper, this.serviceTimeout);
            } else {
                this.messageDeliveryAdapter.deliverAsync(wrapper);
                if (this.asyncResponse != null) {
                    response.getOutputStream().write(StreamUtils.readStream(((Object)((Object)this)).getClass().getResourceAsStream(this.asyncResponse)));
                }
            }
        }
        catch (FaultMessageException fme) {
            Message faultMessage = fme.getReturnedMessage();
            if (faultMessage != null) {
                Object obj = faultMessage.getProperties().getProperty("ReponseStatus");
                if (obj != null && obj instanceof Integer) {
                    response.setStatus(((Integer)obj).intValue());
                } else {
                    response.setStatus(500);
                }
                fme.printStackTrace(response.getWriter());
            }
        }
        catch (Exception ex) {
            response.setStatus(500);
            ex.printStackTrace(response.getWriter());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSupportMethod(METHOD_GET)) {
            this.serveRequest(request, response);
        } else {
            super.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSupportMethod(METHOD_POST)) {
            this.serveRequest(request, response);
        } else {
            super.doPost(request, response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSupportMethod(METHOD_PUT)) {
            this.serveRequest(request, response);
        } else {
            super.doPut(request, response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSupportMethod(METHOD_DELETE)) {
            this.serveRequest(request, response);
        } else {
            super.doDelete(request, response);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean ALLOW_GET;
        boolean ALLOW_HEAD = ALLOW_GET = this.isSupportMethod(METHOD_GET);
        boolean ALLOW_POST = this.isSupportMethod(METHOD_POST);
        boolean ALLOW_PUT = this.isSupportMethod(METHOD_PUT);
        boolean ALLOW_DELETE = this.isSupportMethod(METHOD_DELETE);
        boolean ALLOW_TRACE = true;
        boolean ALLOW_OPTIONS = true;
        String allow = null;
        if (ALLOW_GET && allow == null) {
            allow = METHOD_GET;
        }
        if (ALLOW_HEAD) {
            allow = allow == null ? METHOD_HEAD : allow + ", HEAD";
        }
        if (ALLOW_POST) {
            allow = allow == null ? METHOD_POST : allow + ", POST";
        }
        if (ALLOW_PUT) {
            allow = allow == null ? METHOD_PUT : allow + ", PUT";
        }
        if (ALLOW_DELETE) {
            allow = allow == null ? METHOD_DELETE : allow + ", DELETE";
        }
        if (ALLOW_TRACE) {
            allow = allow == null ? METHOD_TRACE : allow + ", TRACE";
        }
        if (ALLOW_OPTIONS) {
            allow = allow == null ? METHOD_OPTIONS : allow + ", OPTIONS";
        }
        resp.setHeader("Allow", allow);
    }

    private boolean isSupportMethod(String name) {
        return this.allowHttpMethods.indexOf(name) >= 0;
    }

    private void initTransient() throws ConfigurationException {
        this.messageDeliveryAdapter = UncomposedMessageDeliveryAdapter.getGatewayDeliveryAdapter(this.config, new HttpMessageComposer());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.initTransient();
        }
        catch (ConfigurationException ce) {
            IOException ioe = new IOException("Unexpected error deserialising servlet");
            ioe.initCause(ce);
            throw ioe;
        }
    }
}

