/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.schedule.SchedulerJob;
import org.jboss.soa.esb.schedule.SchedulerJobListener;
import org.jboss.soa.esb.schedule.SchedulingException;

public abstract class AbstractScheduledManagedLifecycle
extends AbstractManagedLifecycle {
    private final SchedulerJob job;
    private static final Logger logger = Logger.getLogger(AbstractScheduledManagedLifecycle.class);

    protected AbstractScheduledManagedLifecycle(ConfigTree config) throws ConfigurationException {
        super(config);
        Properties properties = this.extractProperties(config);
        SchedulerJobListener listener = new SchedulerJobListener(){

            public void onSchedule() throws SchedulingException {
                AbstractScheduledManagedLifecycle.this.onSchedule();
            }
        };
        String scheduleIdRef = config.getAttribute("scheduleidref");
        if (scheduleIdRef == null) {
            String intervalVal = config.getAttribute("schedule-frequency");
            long interval = intervalVal != null ? (long)this.parseInt("schedule-frequency", intervalVal) : 10L;
            this.job = SchedulerJob.createIntervalSchedulerJob(null, listener, interval * 1000L, properties);
        } else {
            Date scheduleStartDate = this.getDate(config.getAttribute("scheduleStartDate"));
            Date scheduleEndDate = this.getDate(config.getAttribute("scheduleEndDate"));
            String simpleFrequency = config.getAttribute("scheduleSimpleFrequency");
            if (simpleFrequency != null) {
                long frequency = this.parseLong("scheduleSimpleFrequency", simpleFrequency);
                if (frequency <= 0L) {
                    throw new ConfigurationException("Invalid scheduleSimpleFrequency value, must be greate than zero: " + simpleFrequency);
                }
                String simpleExecCount = config.getAttribute("scheduleSimpleExec");
                if (simpleExecCount != null) {
                    int execCount = this.parseInt("scheduleSimpleExec", simpleExecCount);
                    if (execCount < 0) {
                        this.job = SchedulerJob.createIntervalSchedulerJob(scheduleIdRef, listener, frequency, scheduleStartDate, scheduleEndDate, properties);
                    } else if (execCount == 0) {
                        logger.warn((Object)("<simple-schedule> '" + scheduleIdRef + "' has an execCount of 0 configured.  This schedule will not fire!"));
                        this.job = null;
                    } else {
                        this.job = SchedulerJob.createIntervalSchedulerJob(scheduleIdRef, listener, frequency, execCount, scheduleStartDate, scheduleEndDate, properties);
                    }
                } else {
                    this.job = SchedulerJob.createIntervalSchedulerJob(scheduleIdRef, listener, frequency, scheduleStartDate, scheduleEndDate, properties);
                }
            } else {
                String cronExpression = config.getAttribute("scheduleCronExpression");
                if (cronExpression == null) {
                    throw new ConfigurationException("Missing cron expression");
                }
                try {
                    this.job = SchedulerJob.createCronSchedulerJob(scheduleIdRef, listener, cronExpression, scheduleStartDate, scheduleEndDate, properties);
                }
                catch (ParseException pe) {
                    throw new ConfigurationException("Invalid cron expression", pe);
                }
            }
        }
    }

    protected void doInitialise() throws ManagedLifecycleException {
    }

    protected void doStart() throws ManagedLifecycleException {
        if (this.job != null) {
            try {
                this.job.start();
            }
            catch (SchedulingException se) {
                throw new ManagedLifecycleException("Failed to start the scheduling job", se);
            }
        }
    }

    protected abstract void onSchedule() throws SchedulingException;

    protected void doStop() throws ManagedLifecycleException {
        if (this.job != null) {
            try {
                this.job.pause();
            }
            catch (SchedulingException se) {
                throw new ManagedLifecycleException("Failed to pause the scheduling job", se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doDestroy() throws ManagedLifecycleException {
        try {
            this.doScheduledDestroy();
        }
        finally {
            if (this.job != null) {
                try {
                    this.job.destroy();
                }
                catch (SchedulingException se) {
                    throw new ManagedLifecycleException("Failed to destroy the scheduling job", se);
                }
            }
        }
    }

    protected void doScheduledDestroy() throws ManagedLifecycleException {
    }

    private int parseInt(String propertyName, String value) throws ConfigurationException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Failed to parse " + propertyName + " as integer: " + value);
        }
    }

    private long parseLong(String propertyName, String value) throws ConfigurationException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Failed to parse " + propertyName + " as long: " + value);
        }
    }

    private Properties extractProperties(ConfigTree config) throws ConfigurationException {
        int numChildren;
        ConfigTree[] children = config.getChildren("ScheduleProperties");
        int n = numChildren = children == null ? 0 : children.length;
        if (numChildren == 0) {
            return null;
        }
        if (numChildren > 1) {
            throw new ConfigurationException("Only one ScheduleProperties element allowed within the configuration");
        }
        List<KeyValuePair> attributeList = children[0].attributesAsList();
        if (attributeList == null || attributeList.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (KeyValuePair pair : attributeList) {
            properties.put(pair.getKey(), pair.getValue());
        }
        return properties;
    }

    private Date getDate(String time) throws ConfigurationException {
        long timeval;
        if (time == null) {
            return null;
        }
        try {
            timeval = Long.parseLong(time);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Could not create date from millisecond value: " + time);
        }
        return new Date(timeval);
    }
}

