/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.persistence.manager;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.internal.soa.esb.persistence.manager.J2eeConnectionManager;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.persistence.manager.ConnectionManager;
import org.jboss.soa.esb.persistence.manager.ConnectionManagerException;
import org.jboss.soa.esb.util.ClassUtil;

public class ConnectionManagerFactory {
    private static String DEFAULT = J2eeConnectionManager.class.getName();
    private static Logger logger = Logger.getLogger(ConnectionManagerFactory.class);

    public static ConnectionManager getConnectionManager() throws ConnectionManagerException {
        ConnectionManager manager = null;
        String className = Configuration.getStoreDBConnectionManager();
        if (className == null) {
            className = DEFAULT;
        }
        logger.log((Priority)Level.DEBUG, (Object)("Going to load " + className));
        try {
            Class managerClass = ClassUtil.forName(className, ConnectionManagerFactory.class);
            ConnectionManager tmp = (ConnectionManager)managerClass.newInstance();
            manager = tmp.getInstance();
        }
        catch (ClassNotFoundException cnfex) {
            throw new ConnectionManagerException("Connection Manager Implementation=" + className + " not found", cnfex);
        }
        catch (Exception e) {
            throw new ConnectionManagerException("Invocation exception. " + e.getLocalizedMessage(), e);
        }
        return manager;
    }
}

