/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.schedule;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.schedule.CronSchedule;
import org.jboss.soa.esb.schedule.Schedule;
import org.jboss.soa.esb.schedule.ScheduledEventListener;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.schedule.SimpleSchedule;
import org.jboss.soa.esb.util.ClassUtil;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleProvider {
    private static Logger logger = Logger.getLogger(ScheduleProvider.class);
    private Scheduler scheduler;
    private Map<JobDetail, Trigger> scheduledJobs = new HashMap<JobDetail, Trigger>();
    private List<Schedule> schedules;
    private boolean active;
    private final ClassLoader tcc;
    private static final String JBOSS_ESB = "JBossESB";
    private static volatile int nameDelta = 1;

    public ScheduleProvider(Properties properties, List<Schedule> schedules) throws ConfigurationException {
        try {
            Properties defaultProperties = new Properties();
            InputStream quartzProperties = ClassUtil.getResourceAsStream("quartz.properties", ScheduleProvider.class);
            if (quartzProperties != null) {
                defaultProperties.load(quartzProperties);
            }
            if (properties != null && !properties.isEmpty()) {
                defaultProperties.putAll((Map<?, ?>)properties);
            }
            this.scheduler = !defaultProperties.isEmpty() ? new StdSchedulerFactory(defaultProperties).getScheduler() : new StdSchedulerFactory().getScheduler();
            this.scheduler.start();
            this.tcc = Thread.currentThread().getContextClassLoader();
        }
        catch (SchedulerException e) {
            throw new ConfigurationException("Unable to create Scheduler instance.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to create Scheduler instance. Failed to read", e);
        }
        this.schedules = schedules;
    }

    public void addListener(ScheduledEventListener listener, String scheduleId) throws SchedulingException, ConfigurationException {
        SimpleTrigger trigger;
        Schedule schedule = this.getSchedule(scheduleId);
        if (schedule == null) {
            throw new ConfigurationException("Unknown schedule '" + scheduleId + "' referenced in listener configuration.");
        }
        if (schedule instanceof SimpleSchedule) {
            SimpleSchedule simpleSchedule = (SimpleSchedule)schedule;
            if (simpleSchedule.getExecCount() == -1) {
                trigger = new SimpleTrigger();
                trigger.setRepeatInterval(simpleSchedule.getFrequency());
                trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
            } else {
                if (simpleSchedule.getExecCount() == 0) {
                    logger.warn((Object)("<simple-schedule> '" + scheduleId + "' has an execCount of 0 configured.  This schedule will not fire!"));
                    return;
                }
                trigger = new SimpleTrigger();
                trigger.setRepeatInterval(simpleSchedule.getFrequency());
                trigger.setRepeatCount(simpleSchedule.getExecCount() - 1);
            }
            trigger.setName(simpleSchedule.getScheduleid());
        } else {
            String cronExpression = ((CronSchedule)schedule).getCronExpression();
            try {
                trigger = new CronTrigger(scheduleId, JBOSS_ESB, cronExpression);
            }
            catch (ParseException e) {
                throw new ConfigurationException("Invalid CRON expression '" + cronExpression + "' on schedule '" + scheduleId + "'.", e);
            }
        }
        if (schedule.getStartDate() != null) {
            trigger.setStartTime(schedule.getStartDate().getTime());
        } else {
            trigger.setStartTime(new Date());
        }
        if (schedule.getEndDate() != null) {
            trigger.setEndTime(schedule.getEndDate().getTime());
        }
        this.addListener(listener, (Trigger)trigger);
    }

    public void addListener(ScheduledEventListener listener, long scheduleFrequency) throws SchedulingException {
        Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)((int)scheduleFrequency));
        String name = listener.toString() + scheduleFrequency;
        trigger.setName(name);
        trigger.setStartTime(new Date());
        this.addListener(listener, trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(ScheduledEventListener listener, Trigger trigger) throws SchedulingException {
        Class<ScheduleProvider> clazz = ScheduleProvider.class;
        synchronized (ScheduleProvider.class) {
            int id = nameDelta++;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            JobDataMap jobDataMap = new JobDataMap();
            String name = trigger.getName();
            name = name + "-" + id;
            trigger.setName(name);
            JobDetail jobDetail = new JobDetail(name, JBOSS_ESB, ESBScheduledJob.class);
            jobDataMap.put((Object)ScheduledEventListener.class.getName(), (Object)listener);
            jobDataMap.put((Object)ClassLoader.class.getName(), (Object)this.tcc);
            jobDetail.setJobDataMap(jobDataMap);
            ScheduleProvider scheduleProvider = this;
            synchronized (scheduleProvider) {
                this.scheduledJobs.put(jobDetail, trigger);
                if (this.active) {
                    try {
                        this.scheduler.scheduleJob(jobDetail, trigger);
                    }
                    catch (SchedulerException e) {
                        throw new SchedulingException("Failed to schedule job.", e);
                    }
                }
            }
            return;
        }
    }

    private Schedule getSchedule(String scheduleId) {
        for (Schedule schedule : this.schedules) {
            if (!schedule.getScheduleid().equals(scheduleId.trim())) continue;
            return schedule;
        }
        return null;
    }

    public synchronized void start() throws SchedulingException {
        if (!this.active) {
            try {
                for (Map.Entry<JobDetail, Trigger> entry : this.scheduledJobs.entrySet()) {
                    this.scheduler.scheduleJob(entry.getKey(), entry.getValue());
                }
            }
            catch (SchedulerException e) {
                throw new SchedulingException("Failed to start scheduling.", e);
            }
            this.active = true;
        }
    }

    public synchronized void stop() throws SchedulingException {
        if (this.active) {
            try {
                for (Trigger trigger : this.scheduledJobs.values()) {
                    String jobName = trigger.getName();
                    if (this.scheduler.deleteJob(jobName, JBOSS_ESB)) continue;
                    logger.info((Object)("Failed to delete scheduled Job '" + jobName + "' from job group '" + JBOSS_ESB + "'.  Job run may have already completed."));
                }
            }
            catch (SchedulerException e) {
                throw new SchedulingException("Failed to shutdown scheduling.", e);
            }
            this.active = false;
        }
    }

    public static class ESBScheduledJob
    implements StatefulJob {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            ScheduledEventListener listener = (ScheduledEventListener)jobDataMap.get((Object)ScheduledEventListener.class.getName());
            ClassLoader tcc = (ClassLoader)jobDataMap.get((Object)ClassLoader.class.getName());
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(tcc);
            try {
                listener.onSchedule();
            }
            catch (SchedulingException e) {
                JobExecutionException jobException = new JobExecutionException("Scheduling exception on " + jobExecutionContext.getJobDetail().getName());
                jobException.initCause((Throwable)e);
                throw jobException;
            }
            catch (Throwable th) {
                JobExecutionException jobException = new JobExecutionException("Unexpected exception on " + jobExecutionContext.getJobDetail().getName());
                jobException.initCause(th);
                throw jobException;
            }
            finally {
                thread.setContextClassLoader(currentClassLoader);
            }
        }
    }
}

