/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.crypto.SealedObject;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.PrivateCryptoUtil;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static transient ThreadLocal<SealedObject> securityContextTl = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(SecurityConfig.class);
    private static final long DEFAULT_TIMEOUT_VALUE = 30000L;
    private static final long globalConfiguredTimeout = SecurityContext.getGlobalConfigurationTimeout();
    private final Subject subject;
    private final long timeout;
    private long timeOfCreation = System.currentTimeMillis();

    public SecurityContext() {
        this(new Subject());
    }

    public SecurityContext(Subject subject) {
        this(subject, globalConfiguredTimeout);
    }

    public SecurityContext(Subject subject, long timeout) {
        AssertArgument.isNotNull(subject, "subject");
        this.subject = subject;
        if (timeout < -1L) {
            throw new IllegalArgumentException("'timeout' for SecurityContext must not be negative other then '-1' which indicates a SecurityContext that never expires.");
        }
        this.timeout = timeout;
    }

    public boolean isCallerInRole(String roleName) {
        Set<Principal> principals = this.subject.getPrincipals();
        for (Principal principal : principals) {
            Group group;
            if (!(principal instanceof Group) || !(group = (Group)principal).getName().equalsIgnoreCase("Roles")) continue;
            Enumeration roles = group.members();
            while (roles.hasMoreElements()) {
                Principal role = (Principal)roles.nextElement();
                if (!role.getName().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean compareTo(AuthenticationRequest authrequest) {
        if (authrequest == null) {
            return false;
        }
        Principal authPrincipal = authrequest.getPrincipal();
        if (this.subject.getPrincipals().contains(authPrincipal)) {
            Set<?> authCredentials = authrequest.getCredentials();
            Set<Object> publicCredentials = this.subject.getPublicCredentials();
            for (Object object : authCredentials) {
                if (!publicCredentials.contains(object)) continue;
                return true;
            }
            Set<Object> privateCredentials = this.subject.getPrivateCredentials();
            for (Object object : authCredentials) {
                if (!privateCredentials.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public long getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isValid() {
        if (this.timeout == -1L) {
            return true;
        }
        if (this.timeout == 0L) {
            return false;
        }
        return this.timeOfCreation + this.timeout > System.currentTimeMillis();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext [isValid " + this.isValid() + ", timeout :" + this.timeout + ", timeOfCreation : " + this.timeOfCreation + "]";
    }

    final Set<? extends Principal> getPrincipals() {
        return Collections.unmodifiableSet(this.subject.getPrincipals());
    }

    public static SecurityContext decryptContext(SealedObject sealedObject) throws SecurityServiceException {
        if (sealedObject == null) {
            return null;
        }
        SecurityContext context = null;
        Serializable decrypted = PrivateCryptoUtil.INSTANCE.unSealObject(sealedObject);
        if (decrypted instanceof SecurityContext) {
            context = (SecurityContext)decrypted;
        }
        return context;
    }

    public static SealedObject encryptContext(SecurityContext context) throws SecurityServiceException {
        return PrivateCryptoUtil.INSTANCE.sealObject(context);
    }

    public static long getConfigurationTimeout() throws SecurityServiceException {
        return globalConfiguredTimeout;
    }

    public static void setSecurityContext(SealedObject sealedObject) {
        securityContextTl.set(sealedObject);
    }

    public static SealedObject getSecurityContext() {
        return securityContextTl.get();
    }

    private static long getGlobalConfigurationTimeout() {
        String timeoutStr = Configuration.getSecurityServiceContextTimeout();
        if (timeoutStr == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"No timeout was configured for the security context, using the default value. Please set the value of 'org.jboss.soa.esb.services.security.contextTimeout' to the timeout you desire");
            }
            return 30000L;
        }
        try {
            return Long.parseLong(timeoutStr.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)"The value of 'org.jboss.soa.esb.services.security.contextTimeout' is invalid, using default value");
            return 30000L;
        }
    }
}

