/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;

public final class SOAPExtractorUtil {
    public static final String WSSE_LN = "Security";
    public static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSSE_NS2 = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    public static final String WSSE11_NS = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";

    private SOAPExtractorUtil() {
    }

    public static SOAPHeaderElement getSecurityHeader(SOAPEnvelope env) throws SOAPException {
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader == null) {
            return null;
        }
        Iterator headerElements = soapHeader.examineAllHeaderElements();
        while (headerElements.hasNext()) {
            String nsURI;
            SOAPHeaderElement header = (SOAPHeaderElement)headerElements.next();
            Name name = header.getElementName();
            if (!name.getLocalName().equalsIgnoreCase(WSSE_LN) || !(nsURI = name.getURI()).equalsIgnoreCase(WSSE_NS) && !nsURI.equalsIgnoreCase(WSSE_NS2) && !nsURI.equalsIgnoreCase(WSSE11_NS)) continue;
            return header;
        }
        return null;
    }
}

