/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.jboss.wsf.spi.tools.WSContractConsumer;
import org.jboss.wsf.spi.tools.cmd.WSConsume;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSConsumeTask
extends Task {
    private CommandlineJava command = new CommandlineJava();
    private String wsdl;
    private File destdir;
    private File sourcedestdir;
    private List<File> bindingFiles = new ArrayList<File>();
    private File catalog;
    private String wsdlLocation;
    private String targetPackage;
    private boolean keep;
    private boolean verbose;
    private boolean fork;
    private boolean debug;
    private String target;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Commandline.Argument createJvmarg() {
        return this.command.createVmArgument();
    }

    public void setBinding(File file) {
        this.bindingFiles.add(file);
    }

    public void setCatalog(File file) {
        this.catalog = file;
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public void setSourcedestdir(File file) {
        this.sourcedestdir = file;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setPackage(String string) {
        this.targetPackage = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setWsdl(String string) {
        this.wsdl = string;
    }

    public void setWsdlLocation(String string) {
        this.wsdlLocation = string;
    }

    public void addConfiguredBinding(FileSet fileSet) {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = directoryScanner.getBasedir();
        for (String string : directoryScanner.getIncludedFiles()) {
            this.bindingFiles.add(new File(file, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonForked() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader2);
        try {
            WSContractConsumer wSContractConsumer = WSContractConsumer.newInstance();
            wSContractConsumer.setGenerateSource(this.keep);
            if (this.destdir != null) {
                wSContractConsumer.setOutputDirectory(this.destdir);
            }
            if (this.sourcedestdir != null) {
                wSContractConsumer.setSourceDirectory(this.sourcedestdir);
            }
            if (this.targetPackage != null) {
                wSContractConsumer.setTargetPackage(this.targetPackage);
            }
            if (this.wsdlLocation != null) {
                wSContractConsumer.setWsdlLocation(this.wsdlLocation);
            }
            if (this.catalog != null) {
                wSContractConsumer.setCatalog(this.catalog);
            }
            if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
                wSContractConsumer.setBindingFiles(this.bindingFiles);
            }
            if (this.target != null) {
                wSContractConsumer.setTarget(this.target);
            }
            this.log("Consuming wsdl: " + this.wsdl, 2);
            if (this.verbose) {
                wSContractConsumer.setMessageStream(new PrintStream((OutputStream)new LogOutputStream((Task)this, 2)));
            }
            try {
                wSContractConsumer.setAdditionalCompilerClassPath(this.getTaskClassPathStrings());
                wSContractConsumer.consume(this.wsdl);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException((Throwable)malformedURLException, this.getLocation());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void execute() throws BuildException {
        if (this.wsdl == null) {
            throw new BuildException("The wsdl attribute must be specified!", this.getLocation());
        }
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeNonForked();
        }
    }

    private Path getTaskClassPath() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader instanceof AntClassLoader) {
            return new Path(this.getProject(), ((AntClassLoader)classLoader).getClasspath());
        }
        return new Path(this.getProject());
    }

    private List<String> getTaskClassPathStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader instanceof AntClassLoader) {
            for (String string : ((AntClassLoader)classLoader).getClasspath().split(File.pathSeparator)) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void executeForked() throws BuildException {
        this.command.setClassname(WSConsume.class.getName());
        Path path = this.command.createClasspath(this.getProject());
        path.append(this.getTaskClassPath());
        if (this.keep) {
            this.command.createArgument().setValue("-k");
        }
        for (File file : this.bindingFiles) {
            this.command.createArgument().setValue("-b");
            this.command.createArgument().setFile(file);
        }
        if (this.catalog != null) {
            this.command.createArgument().setValue("-c");
            this.command.createArgument().setFile(this.catalog);
        }
        if (this.targetPackage != null) {
            this.command.createArgument().setValue("-p");
            this.command.createArgument().setValue(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            this.command.createArgument().setValue("-w");
            this.command.createArgument().setValue(this.wsdlLocation);
        }
        if (this.destdir != null) {
            this.command.createArgument().setValue("-o");
            this.command.createArgument().setFile(this.destdir);
        }
        if (this.sourcedestdir != null) {
            this.command.createArgument().setValue("-s");
            this.command.createArgument().setFile(this.sourcedestdir);
        }
        if (this.target != null) {
            this.command.createArgument().setValue("-t");
            this.command.createArgument().setValue(this.target);
        }
        if (this.verbose) {
            this.command.createArgument().setValue("-v");
        }
        this.command.createArgument().setValue(this.wsdl);
        this.log("Consuming wsdl: " + this.wsdl, 2);
        if (this.verbose) {
            this.log("Command invoked: " + this.command.getJavaCommand().toString());
        }
        ExecuteJava executeJava = new ExecuteJava();
        executeJava.setClasspath(path);
        executeJava.setJavaCommand(this.command.getJavaCommand());
        if (executeJava.fork((ProjectComponent)this) != 0) {
            throw new BuildException("Could not invoke WSConsumeTask", this.getLocation());
        }
    }
}

