/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.sourceforge.wife.swift.model.SwiftTagListBlock;
import net.sourceforge.wife.swift.model.Tag;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SwiftBlockUser
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Integer sortKey;
    protected String blockName;

    public SwiftBlockUser() {
        this.setBlockName("0");
    }

    public SwiftBlockUser(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)"'blockNumber' is not a valid User Defined Block number");
        this.setBlockNumber(blockNumber);
    }

    public SwiftBlockUser(Integer blockNumber, List tags) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)"'blockNumber' is not a valid User Defined Block number");
        Validate.allElementsOfType((Collection)tags, (Class)Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.setBlockNumber(blockNumber);
        this.addTags(tags);
    }

    public SwiftBlockUser(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)"'blockName' is not a valid User Defined Block name");
        this.setBlockName(blockName);
    }

    public SwiftBlockUser(String blockName, List tags) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)"'blockName' is not a valid User Defined Block name");
        Validate.allElementsOfType((Collection)tags, (Class)Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.setBlockName(blockName);
        this.addTags(tags);
    }

    public Integer getNumber() {
        Integer blockNumber = new Integer(-1);
        try {
            blockNumber = Integer.decode(this.blockName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return blockNumber;
    }

    public String getName() {
        return this.getBlockName();
    }

    public String getBlockName() {
        return this.blockName;
    }

    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)("'" + blockNumber.toString() + "' is not a valid User Defined Block number"));
        this.blockName = blockNumber.toString();
    }

    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)("'" + blockName + "' is not a valid User Defined Block name"));
        this.blockName = blockName;
    }

    protected Boolean isValidName() {
        return SwiftBlockUser.isValidName(this.getName(), this.getNumber());
    }

    public static Boolean isValidName(String blockName, Integer blockNumber) {
        return SwiftBlockUser.isValidName(blockName) != false && SwiftBlockUser.isValidName(blockNumber) != false;
    }

    public static Boolean isValidName(String blockName) {
        if (blockName == null) {
            return Boolean.FALSE;
        }
        try {
            Integer num = Integer.decode(blockName);
            if (!SwiftBlockUser.isValidName(num).booleanValue()) {
                return Boolean.FALSE;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (blockName.length() != 1) {
            return Boolean.FALSE;
        }
        char c = Character.toLowerCase(blockName.charAt(0));
        if (!('0' <= c && c <= '9' || 'a' <= c && c <= 'z')) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isValidName(Integer blockNumber) {
        if (blockNumber == null) {
            return Boolean.FALSE;
        }
        if (blockNumber != -1 && 1 <= blockNumber && blockNumber <= 5) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(Integer sortKey) {
        this.sortKey = sortKey;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.blockName == null ? 0 : this.blockName.hashCode());
        result = 31 * result + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlockUser other = (SwiftBlockUser)obj;
        if (this.blockName == null ? other.blockName != null : !this.blockName.equals(other.blockName)) {
            return false;
        }
        return !(this.sortKey == null ? other.sortKey != null : !this.sortKey.equals(other.sortKey));
    }
}

