/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Section {
    private String[] section;
    private String info;
    private static final String DELIMETER = ".";
    private static final String PARSE_SECTION_ERROR = "Section token cannot be longer than one character";
    private static final String GET_SECTION_INDEX_ERROR = "Section index too large";
    private static final String CONSTRUCTION_ERROR = "Cannot parse section string";

    public Section(String id) {
        try {
            this.section = this.parseSection(id);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(CONSTRUCTION_ERROR);
        }
    }

    public Section(String id, String info) {
        this(id);
        this.info = info;
    }

    public String getSectionToken(int index) {
        if (this.section.length >= index) {
            throw new IndexOutOfBoundsException(GET_SECTION_INDEX_ERROR);
        }
        return this.section[index];
    }

    public Iterator getSectionTokens() {
        return Collections.unmodifiableList(Arrays.asList(this.section)).iterator();
    }

    public String getSection() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.section.length; ++i) {
            buffer.append(this.section[i]);
            if (i + 1 >= this.section.length) continue;
            buffer.append(DELIMETER);
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.info != null) {
            return this.getSection() + ": " + this.info;
        }
        return this.getSection();
    }

    public boolean hasInfo() {
        return this.info != null;
    }

    public String getInfo() {
        return this.info;
    }

    private String[] parseSection(String id) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(id, DELIMETER);
        String[] token = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            token[i] = tokenizer.nextToken();
            ++i;
        }
        return token;
    }
}

