/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.WifeException;
import net.sourceforge.wife.services.IConversionService;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.parser.SwiftParser;
import net.sourceforge.wife.swift.parser.XMLParser;
import net.sourceforge.wife.swift.writer.SwiftWriter;
import net.sourceforge.wife.swift.writer.XMLWriterVisitor;
import org.apache.commons.lang.Validate;

public class ConversionService
implements IConversionService {
    private static final transient Logger log = Logger.getLogger(ConversionService.class.getName());

    public String getFIN(SwiftMessage msg) {
        Validate.notNull((Object)msg);
        SwiftWriter w = new SwiftWriter();
        StringWriter writer = new StringWriter();
        w.writeMessage(msg, writer);
        return writer.getBuffer().toString();
    }

    public String getFIN(String xml) {
        Validate.notNull((Object)xml);
        SwiftMessage msg = this.getMessageFromXML(xml);
        if (msg == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        return this.getFIN(msg);
    }

    public String getXml(SwiftMessage msg) {
        Validate.notNull((Object)msg);
        StringWriter w = new StringWriter();
        msg.visit(new XMLWriterVisitor(w));
        String xml = w.getBuffer().toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine("xml: " + xml);
        }
        return xml;
    }

    public String getXml(String fin) {
        Validate.notNull((Object)fin);
        SwiftMessage msg = this.getMessageFromFIN(fin);
        return this.getXml(msg);
    }

    public SwiftMessage getMessageFromFIN(String fin) {
        Validate.notNull((Object)fin);
        SwiftParser p = new SwiftParser(new ByteArrayInputStream(fin.getBytes()));
        try {
            return p.message();
        }
        catch (IOException e) {
            throw new WifeException(e + " during parse of message");
        }
    }

    public SwiftMessage getMessageFromXML(String xml) {
        return new XMLParser().parse(xml);
    }

    static {
        log.info("$Id: ConversionService.java,v 1.5 2007/07/25 17:56:09 mikkey Exp $");
    }
}

