/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp;

/**
 * References webservice endpoint deployment properties.
 *  
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ServiceEndpointReference
{
  private String endpointId;
  private java.net.URL serviceUrl;
  private String deploymentName;
  private String archiveLocation;

  public ServiceEndpointReference(String endpointId, java.net.URL location, String deploymentName,
		  						String archiveLocation)
  {
    this.endpointId = endpointId;
    this.serviceUrl = location;
    this.deploymentName = deploymentName;
    this.archiveLocation = archiveLocation;
  }

  public String getArchiveLocation()
  {
    return archiveLocation;
  }

  public String getEndpointId()
  {
    return endpointId;
  }

  public java.net.URL getServiceUrl()
  {
    return serviceUrl;
  }

  public String getDeploymentName()
  {
    return deploymentName;
  }

  @Override
  public boolean equals(Object o)
  {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ServiceEndpointReference that = (ServiceEndpointReference) o;

    if (!archiveLocation.equals(that.archiveLocation)) return false;
    if (!deploymentName.equals(that.deploymentName)) return false;
    if (!endpointId.equals(that.endpointId)) return false;
    if (!serviceUrl.equals(that.serviceUrl)) return false;

    return true;
  }

  @Override
  public int hashCode()
  {
    int result = endpointId.hashCode();
    result = 31 * result + serviceUrl.hashCode();
    result = 31 * result + deploymentName.hashCode();
    result = 31 * result + archiveLocation.hashCode();
    return result;
  }
}
