/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.server;

import java.io.File;

/**
 * Default base implementation of the server independent config.
 * This class should be derived to provide the required information.
 *
 */
public abstract class DefaultServerConfig implements ServerConfig {
	
	/**
	 * This method returns the server's temp directory. This directory
	 * will be used to create the deployable archive before actual
	 * deployment.
	 * 
	 * @return The temp directory
	 */
	public File getServerTempDir() {
		throw new UnsupportedOperationException();
	}

	/**
	 * This method returns the directory where the deployable archive
	 * should be placed.
	 * 
	 * @return The deployment directory
	 */
	public File getServerDeployDir() {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * This method returns the web service host.
	 * 
	 * @return The web service host
	 */
	public String getWebServiceHost() {
		throw new UnsupportedOperationException();
	}

	/**
	 * This method returns the web service port.
	 * 
	 * @return The web service port
	 */
	public int getWebServicePort() {
		throw new UnsupportedOperationException();
	}

	/**
	 * This method returns the secure web service port number.
	 * 
	 * @return The secure web service port number
	 */
	public int getWebServiceSecurePort() {
		throw new UnsupportedOperationException();
	}

	/**
	 * This method returns the server's cluster node name.
	 * 
	 * @return The cluster node name
	 */
	public String getClusterNodeName() {
		throw new UnsupportedOperationException();
	}
	  
	/**
	 * This method returns the server's UDDI node name.
	 * 
	 * @return The UDDI node name
	 */
	public String getUddiNodeName() {
		throw new UnsupportedOperationException();
	}
	
}