/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.ws;

import javax.wsdl.Definition;

import java.net.URI;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * Used to pass along both parsed and raw WSDL references.
 *
 * @see org.jboss.soa.bpel.runtime.engine.ode.JAXWSBindingContext
 * @see org.jboss.soa.bpel.runtime.ws.EndpointManager
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 * @author Kurt.Stam <kurt.stam@jboss.com>
 * 
 */
public final class WSDLReference
{
  private Definition definition;
  private URI wsdlURI;

  public WSDLReference(Definition definition, URI wsdlURI)
  {
    this.definition = definition;
    this.wsdlURI = wsdlURI;
  }

  public Definition getDefinition()
  {
    return definition;
  }

  public URL getWsdlURL()
  {
    try
    {
      return wsdlURI.toURL();
    }
    catch (MalformedURLException e)
    {
      throw new RuntimeException(e);
    }
  }
}
