/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.server.tomcat;

import java.io.File;

import org.jboss.soa.dsp.server.ServerConfig;

public class TomcatServerConfigFactory implements org.jboss.soa.dsp.server.ServerConfigFactory {

	public ServerConfig getServerConfig() {
		ServerConfig ret=new ServerConfig() {

			protected File getTomcatRoot() {
				String path=System.getenv("CATALINA_HOME");
				
				if (path == null) {
					return(null);
				}
				
				return(new File(path));
			}

			public File getServerTempDir() {
				File tomcat=getTomcatRoot();
				if (tomcat == null) {
					return(null);
				}
				return(new java.io.File(tomcat, "temp"));
			}

			public File getServerDeployDir() {
				File tomcat=getTomcatRoot();
				if (tomcat == null) {
					return(null);
				}
				return(new java.io.File(tomcat, "webapps"));
			}

			public String getWebServiceHost() {
				throw new UnsupportedOperationException();
			}

			public int getWebServicePort() {
				throw new UnsupportedOperationException();
			}

			public int getWebServiceSecurePort() {
				throw new UnsupportedOperationException();
			}

			public String getClusterNodeName() {
				throw new UnsupportedOperationException();
			}

			public String getUddiNodeName() {
				throw new UnsupportedOperationException();
			}
		};
		
		return(ret);
	}

}
