/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.example;

import java.io.IOException;
import java.io.PrintWriter;

public class DSPExampleForm {

	public static void buildForm(PrintWriter out) throws IOException {
		
		out.println("<h2>Deploy Web Service</h2>");
		out.println("<form action=\"DeployServlet\" enctype=\"multipart/form-data\" method=\"POST\">");
		out.println("\t<input type=\"file\" name=\"file1\"><br>");
		out.println("\t<input type=\"Submit\" value=\"Deploy\"><br>");
		out.println("</form>");
		
		java.util.Set<String> keys=DeployStore.keys();
		
		if (keys.size() > 0) {
		
			out.println("======================================================================<br>");
			out.println("<h2>Undeploy Web Service</h2>");
			
			out.println("<form action=\"UndeployServlet\" method=\"post\">");
			out.println("<table>");
			out.println("<tr>");
	
			out.println("<select name=\"seref\">");
	
			for (String key : keys) {
				//out.println("<td><textarea rows=\"5\" cols=\"50\" name=\"seref\">"+key+"</textarea></td>");
				out.println("<option value=\""+key+"\">"+key+"</option>");
			}
	
			out.println("</select>");
	
			out.println("<td><input type=\"submit\" value=\"Undeploy\"></td>");
			out.println("</tr>");
			out.println("</table>");
			out.println("</form>");
		}
	}
}
