/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.example.provider;

import javax.xml.namespace.QName;

import org.jboss.soa.dsp.ServiceProvider;
import org.jboss.soa.dsp.ws.SOAPMessageAdapter;
import org.jboss.soa.dsp.ws.WSInvocationAdapter;
import org.jboss.soa.dsp.ws.WebServiceProviderFactory;

public class ExampleWebServiceFactory implements WebServiceProviderFactory {

	public ServiceProvider getServiceProvider() {
		return(new ExampleServiceProvider());
	}

	public WSInvocationAdapter getInvocationAdapter(String operationName,
			QName serviceName, String portName, SOAPMessageAdapter soapAdapter) {
		return(new WSInvocationAdapter(operationName,
					serviceName, portName, soapAdapter));
	}
}
