/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ode.bpel.iapi;

import java.io.Serializable;

/**
 * The user-selectable states of a process in the configuration store.
 * @author mszefler
 */
public enum ProcessState implements Serializable{
    /** Process can create new instances and execute old instances. */
    ACTIVE,
    
    /** Process can execute old instances, but cannot create new instances. */
    RETIRED,
    
    /** Process cannot exeucte old nor create new instances. */
    DISABLED
}
