/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.testcases;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the RiftSaw_154 testcase.
 */
public class RiftSaw154TestCase extends RiftSawTest {

	private static final String TEST_NAME = "RiftSaw_154";

	public RiftSaw154TestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(RiftSaw154TestCase.class,
						TEST_NAME, "RiftSaw_154-1.jar"));
	}

	public void testSendHello() throws Exception {
		// Just check whether sending SOAP request results in
		// an exception
		String result=sendSOAPMessage("hello_request1.xml",
					"http://localhost:8080/RiftSaw_154WS");
		
		if (result != null && result.indexOf("Fault") != -1) {
			fail("Fault returned from oneway test");
		}
	}
}
