/*
 * Copyright 2001-2009 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.juddi.v3.auth;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * User object which contains the userid (publisherId) and a password credential.
 * 
 * @author <a href="mailto:kstam@apache.org">Kurt T Stam</a>
 */
@XmlRootElement(name="user")
public class User {
	
	private String userid;
	private String password;
	
	public User() {}
	
	public User(String userid, String password) {
		super();
		this.userid = userid;
		this.password = password;
	}
	
	@XmlAttribute
	public String getUserid() {
		return userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}

	@XmlAttribute
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String toString()
	{
		StringBuffer buff = new StringBuffer(75);
		buff.append(userid);
		buff.append(" | ");
		buff.append(password);
		return buff.toString();
	}
	
}
