/* JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 */

package org.jboss.internal.soa.esb.addressing.eprs;

import org.jboss.soa.esb.addressing.eprs.InVMEpr;

import java.net.URI;
import java.net.URISyntaxException;

public class DefaultInVMReplyToEpr extends InVMEpr {

    private static ThreadLocal<Long> counter = new ThreadLocal<Long>() ;

    public DefaultInVMReplyToEpr(InVMEpr epr) {
        super(createEprAndCourier());
    }

    private static InVMEpr createEprAndCourier() {
        try {
            final InVMEpr epr = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://thread-" + Thread.currentThread().getId() + "-" + getNextCounter()));
            epr.setTemporaryEPR(true) ;
            return epr ;
        } catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected Exception creating replyTo InVMEpr.", e);
        }
    }
    
    private static long getNextCounter() {
        final Long current = counter.get() ;
        final long value ;
        if (current != null) {
            value = current.longValue() + 1 ;
        } else {
            value = 0 ;
        }
        
        counter.set(Long.valueOf(value)) ;
        return value ;
    }
}