/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.listeners.war;

import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.internal.soa.esb.assertion.AssertArgument;

import java.util.List;
import java.util.ArrayList;

/**
 * Abstract web component model.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public abstract class AbstractWebComponent {
    
    private String name;
    private String runtimeClass;
    private WebModel webModel;
    private List<KeyValuePair> params = new ArrayList<KeyValuePair>();

    public AbstractWebComponent(String name, String runtimeClass, WebModel webModel) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNullAndNotEmpty(runtimeClass, "runtimeClass");
        AssertArgument.isNotNull(webModel, "webModel");
        this.name = name;
        this.runtimeClass = runtimeClass;
        this.webModel = webModel;
    }

    public String getName() {
        return name;
    }

    public String getRuntimeClass() {
        return runtimeClass;
    }

    public WebModel getWebModel() {
        return webModel;
    }

    public List<KeyValuePair> getParams() {
        return params;
    }
}
