/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

/**
 * Wrapped topic subscriber class.
 */
class WrappedXASession extends WrappedSession implements XASession
{
    /**
     * The session.
     */
    private final XASession xaSession ;

    /**
     * Construct the wrapped topic subscriber.
     * @param connectionPool The connection pool associated with the session.
     * @param session The session.
     */
    public WrappedXASession(final JmsConnectionPool connectionPool, final XASession xaSession)
    {
        super(connectionPool, xaSession) ;
        this.xaSession = xaSession ;
    }

    public Session getSession()
        throws JMSException
    {
        try
        {
            return xaSession.getSession() ;
        }
        catch (final JMSException jmse)
        {
            connectionPool.handleException(jmsSession, jmse) ;
            throw jmse ;
        }
    }
    
    public XAResource getXAResource()
    {
        return xaSession.getXAResource() ;
    }
}
