package org.jboss.internal.soa.esb.services.registry;

import java.util.Hashtable;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;

import org.apache.log4j.Logger;

import java.util.Stack;

/**
 * JAXR Connection Singleton.
 * <p/>
 * Provides a cache for JAXRConnection.
 *
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class JAXRConnectionSingleton {
	private static Logger logger = Logger.getLogger(JAXRConnectionSingleton.class);

	private static JAXRConnectionSingleton instance = new JAXRConnectionSingleton();
	private static Hashtable cachedConnectionHash = new Hashtable();
	
	private JAXRConnectionSingleton() {
	}

	/**
	 * Return a connection, from the cache if possible.
	 * @param factory
	 * @return connection
	 */
	public static Connection getConnection(JAXRConnectionFactory factory) {
		if (instance == null) {
			instance = new JAXRConnectionSingleton();
		}
		
		if (cachedConnectionHash.containsKey(factory)) {
			Stack stack = (Stack) cachedConnectionHash.get(factory);
			try {
				Connection connection = null;
				if (stack.isEmpty()) {
					connection = factory.getConnection();
					return connection;
				} else {
					connection = (Connection) stack.pop();
					if ((connection != null) && (!connection.isClosed())) {
						return connection;
					} else {
						logger.error("Cached connection was null or closed, creating new connection");
						connection = factory.getConnection();
						return connection;
					}
				}
			} catch (JAXRException jaxre) {
				return null;
			}
		} else {
			Stack stack = new Stack();
			cachedConnectionHash.put(factory, stack);
			Connection connection = factory.getConnection();
			return connection;
		}		
	}
	
    /**
     * Recycle connection to the cache.
     * @param factory
     * @param connection
     */
    public static void recycleConnection(JAXRConnectionFactory factory,
    		Connection connection) {
    	if (instance == null) {
            instance = new JAXRConnectionSingleton();
    	} else {
            if (cachedConnectionHash.containsKey(factory)) {
            	Stack stack = (Stack) cachedConnectionHash.get(factory);
            	stack.push(connection);
            } else {
            	Stack stack = new Stack();
            	stack.push(connection);
            	cachedConnectionHash.put(factory, stack);
            }
    	}
    }
}