/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.security;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/**
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class UserPassCallbackHandler implements EsbCallbackHandler
{
	private Logger log = Logger.getLogger(UserPassCallbackHandler.class);
	
	private AuthenticationRequest authRequest;

    private final boolean throwUnsupportedCallbackException;
    
    public UserPassCallbackHandler()
    {
		throwUnsupportedCallbackException = true;
    }
	
	public UserPassCallbackHandler(final AuthenticationRequest authRequest, final boolean throwUnsupportedCallbackException)
	{
	    this.authRequest = authRequest;
        this.throwUnsupportedCallbackException = throwUnsupportedCallbackException;
	}
	
	public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException
	{
		if ( authRequest == null )
			throw new IllegalStateException("No AuthenticationRequest has been set");
		
		if (log.isDebugEnabled()) log.debug("Nr of callback to handle : " + callbacks.length);
		for (int i = 0; i < callbacks.length; i++) 
		{
    		if (log.isDebugEnabled()) log.debug("Callback" + callbacks[i].getClass().getName());
            if (callbacks[i] instanceof NameCallback) 
            {
                NameCallback nc = (NameCallback) callbacks[i];
                nc.setName(authRequest.getPrincipal().getName());
            }
            else if (callbacks[i] instanceof PasswordCallback) 
            {
                PasswordCallback pc = (PasswordCallback) callbacks[i];
                for (Object object : authRequest.getCredentials() )
				{
                	if ( object instanceof char[] )
                	{
                        pc.setPassword((char[]) object);
                	}
                	else if ( object instanceof String )
                	{
                        pc.setPassword( ((String) object).toCharArray() );
                	}
				}
            } 
            else 
            {
                if (throwUnsupportedCallbackException)
	            	throw new UnsupportedCallbackException(callbacks[i], "UserPassCallbackHandler");
            }
        }
	}
	
	public void setAuthenticationRequest(AuthenticationRequest authRequest)
	{
		this.authRequest = authRequest;
	}
	
	protected AuthenticationRequest getAuthRequest()
	{
	    return authRequest;
	}

	public void setSecurityConfig(SecurityConfig config) { }
}
