/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;

/**
 * Cached event information for Attribute.
 */
public class ESBStaxAttribute extends ESBStaxXMLEvent implements Attribute
{
    private final String dtdType ;
    private final QName name ;
    private final String value ;
    private final boolean specified ;

    public ESBStaxAttribute(final Attribute attribute)
    {
        super(attribute) ;
        dtdType = attribute.getDTDType() ;
        name = attribute.getName() ;
        value = attribute.getValue() ;
        specified = attribute.isSpecified() ;
    }

    public String getDTDType()
    {
        return dtdType ;
    }

    public QName getName()
    {
        return name ;
    }

    public String getValue()
    {
        return value ;
    }

    public boolean isSpecified()
    {
        return specified ;
    }

    @Override
    public boolean isAttribute()
    {
        return true ;
    }

    static List<Attribute> getAttributes(final Iterator<Attribute> attributes)
    {
        if (attributes == null)
        {
            return null ;
        }
        else if (attributes.hasNext())
        {
            final List<Attribute> result = new ArrayList<Attribute>() ;
            do
            {
                result.add(new ESBStaxAttribute(attributes.next())) ;
            }
            while(attributes.hasNext()) ;
            return result ;
        }
        else
        {
            return Collections.emptyList() ;
        }
    }
}
