/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

/**
 * XStream configuration class that holds information about field
 * aliases.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class FieldAliasConf
{
    private String alias;
    private Class<?> definedIn;
    private String fieldName;

    public FieldAliasConf(final String alias, final String definedIn, final String fieldName)
    {
        AssertArgument.isNotNullAndNotEmpty(alias, "alias");
        AssertArgument.isNotNullAndNotEmpty(definedIn, "definedIn");
        AssertArgument.isNotNullAndNotEmpty(fieldName, "fieldName");
        this.alias = alias;
        this.definedIn = loadClass(definedIn);
        this.fieldName = fieldName;
    }

    public String getAlias()
    {
        return alias;
    }

    public Class<?> getDefinedIn()
    {
        return definedIn;
    }

    public String getFieldName()
    {
        return fieldName;
    }

    public String toString()
    {
        return "FieldAliasConf [alias=" + alias + ", definedIn=" + definedIn + ", fieldName=" + fieldName + "]";
    }
    
    private Class<?> loadClass(final String className)
    {
        try
        {
            return ClassUtil.forName(className, getClass());
        } 
        catch (final ClassNotFoundException e)
        {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }

}
