/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

/**
 * XStream configuration class that holds information about implicit 
 * collections.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class ImplicitCollectionConf
{
    private Class<?> ownerType;
    private String fieldName;
    private String itemFieldName;
    private Class<?> itemType;

    public ImplicitCollectionConf(final String ownerType, final String fieldName, final String itemFieldName, final String itemType)
    {
        AssertArgument.isNotNullAndNotEmpty(ownerType, "ownerType");
        AssertArgument.isNotNullAndNotEmpty(fieldName, "fieldName");
        this.ownerType = loadClass(ownerType);
        this.fieldName = fieldName;
        this.itemFieldName = itemFieldName;
        if (itemType != null)
        {
            this.itemType = loadClass(itemType);
        }
    }

    public Class<?> getOwnerType()
    {
        return ownerType;
    }

    public String getFieldName()
    {
        return fieldName;
    }
    
    public String getItemFieldName()
    {
        return itemFieldName;
    }

    public Class<?> getItemType()
    {
        return itemType;
    }

    public String toString()
    {
        return "ImplicitCollectionConf [ownerType=" + ownerType + ", fieldName=" + fieldName + ", itemFieldName=" + itemFieldName + ", itemType=" + itemType + "]";
    }
    
    private Class<?> loadClass(final String className)
    {
        try
        {
            return ClassUtil.forName(className, getClass());
        } 
        catch (final ClassNotFoundException e)
        {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}
