/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers;

/**
 * Exception used for Naming Connection Pool errors.
 */
public class NamingContextException extends Exception
{
    /**
     * The serial version UID for this exception.
     */
    private static final long serialVersionUID = 8246625119667566368L;

    /**
     * Create a naming context exception.
     */
    public NamingContextException()
    {
        super() ;
    }

    /**
     * Create a naming context exception with the specified message.
     * @param message The message associated with the exception.
     */
    public NamingContextException(final String message)
    {
        super(message) ;
    }

    /**
     * Create a naming context exception with the specified cause.
     * @param cause The cause associated with the exception.
     */
    public NamingContextException(final Throwable cause)
    {
        super(cause) ;
    }

    /**
     * Create a naming context exception with the specified message and cause.
     * @param message The message associated with the exception.
     * @param cause The cause associated with the exception.
     */
    public NamingContextException(final String message, final Throwable cause)
    {
        super(message, cause) ;
    }
}
