/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.config.mappers130;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.xbeanmodel130.GroovyListenerDocument;
import org.jboss.soa.esb.listeners.gateway.GroovyGateway;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.w3c.dom.Element;

/**
 * Config mapper class for the Groovy Listener.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class GroovyListenerMapper {

    public static Element map(Element root, GroovyListenerDocument.GroovyListener listener, XMLBeansModel model) throws ConfigurationException {
        Element listenerNode = YADOMUtil.addElement(root, "listener");

        listenerNode.setAttribute("name", listener.getName());

        // Map the standard listener attributes - common across all listener types...
        MapperUtil.mapDefaultAttributes(listener, listenerNode, model);
        // Map the <property> elements targeted at the listener - from the listener itself.
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);

        if(listener.getIsGateway()) {
            listenerNode.setAttribute("gatewayClass", GroovyGateway.class.getName());
        } else {
            listenerNode.setAttribute(ListenerTagNames.LISTENER_CLASS_TAG, GroovyGateway.class.getName());
        }

        listenerNode.setAttribute("script", listener.getScript());

        return listenerNode;
    }
}
